/* count.h
 *
 * Pieter Eendebak <pte@ddsw.nl>
 */

#ifndef COUNT_H
#define COUNT_H

#include "includes.h"
#include "go_board.h"
#include "zone_board.h"

#define BEGIN 0
#define REMOVE_DEAD_PIECES 1
#define ALLOCATE_ZONES 2
#define COUNT_TOTAL 3
#define DONE 4


/**
 * This dialog is used to help couting te score. Counting
 * a Go score is something easy to men, but almost impossible
 * to a computer. Therefore the player has to determine
 * his own score.
 * 
 * @short Select game type
 */
class CountDialog : public QFrame
{
	Q_OBJECT
public:	
	CountDialog( KGoBoard *b, QWidget *parent, const char * ) ;
	~CountDialog() ;

	int getProgress() ;
	void resize( int, int ) ;
	void resize() ;

public slots:
	void receiveInput( int, int, int ) ;

	// emulate a QDialog
	void exec() ;
	void accept() ;
	void reject() ;

protected slots:
	void nextStep() ;

signals:
	void countingReady() ;

protected:
	void begin() ;
	void removeDeadPieces() ;
	void allocateZones() ;
	void countTotal() ;
	void end() ;

private:
        QPushButton *ok, *cancel ;
	QLabel *info ;

	KGoBoard *board ;
	KZoneBoard *zoneboard ;

	int progress ;
} ;

#endif
