/* netdialog.cpp
 *
 * Pieter Eendebak <pte@ddsw.nl>
 */

#include "includes.h"
#include "netdialog.moc"
#include "knetobject.h"

#include <ksock.h>


#define ADD_LABEL( label, str, x, y, w, h ) \
	{	label = new QLabel(str, this); \
		label->setGeometry(x, y, w, h); \
	}
 
#define ADD_BUTTON( button, str, x, y, w, h, slot) \
	{	button = new QPushButton(str, this); \
		button->setGeometry(x, y, w, h); \
		connect( button, SIGNAL(clicked()), SLOT(slot) ); \
	}

/* ##########################
 * #	class NetDialog     #
 * ##########################
 */

NetDialog::NetDialog( QWidget *parent )
        : QDialog( parent, 0, TRUE),
		server( 0 ), client( 0 ), netobject( 0 )
{
	setCaption( i18n("Kgo Network Game") ) ;

	ADD_BUTTON( server_button, i18n("Server mode"),
		10, 10, 100, 20, server_clicked() )
	ADD_BUTTON( client_button, i18n("Client mode"),
		10, 40, 100, 20, client_clicked() ) 

	ADD_LABEL( info, i18n("Select options"),
			10, 10, 200, 40 ) 
	ADD_LABEL( address_label, i18n("Address:"),
			10, 60, 80, 20 ) 
	address = new QLineEdit( this ) ;
	address->setGeometry( 100, 60, 80, 20 ) ;
	address->setText( DEFAULT_HOST ) ;
	ADD_LABEL( port_label, i18n("Port:"),
			10, 100, 80, 20 ) 
	port = new KIntegerLine( this ) ;
	port->setGeometry( 100, 100, 80, 20 ) ;
	port->setValue( DEFAULT_PORT ) ;
	port->setMaxLength( 6 ) ;
	// TODO: wait for new version of kdelibs
//	port->setMinimumValue( 1000 ) ;
//	port->setMaximumValue( 7000 ) ;

	ADD_BUTTON( ok, i18n("Ok"), 10, 140, 100, 20, ok_clicked() ) ;
	ADD_BUTTON( cancel, i18n("Cancel"), 120, 140, 100, 20, reject() ) ;

	choose_mode() ;
	adjustSize() ;
}

NetDialog::~NetDialog()
{
}

KNetObject* NetDialog::getNetObject()
{
	return netobject ;
}

bool NetDialog::isServer()
{
	return current_state==SERVER_CONNECTED ;
}

void NetDialog::show_mode()
{
	server_button->show() ;
	client_button->show() ;

	info->hide() ;
	address_label->hide() ;
	address->hide() ;
	port_label->hide() ;
	port->hide() ;

	ok->hide() ;
	cancel->show() ;
}

void NetDialog::choose_mode()
{
	current_state = CHOOSE_MODE ;
	show_mode() ;
}

void NetDialog::show_serverclient( int sc )
{
	server_button->hide() ;
	client_button->hide() ;

	info->show() ;
	address_label->show() ;
	address->show() ;
	address->setEnabled( sc!=SERVER ) ;
	port_label->show() ;
	port->show() ;

	ok->show() ;
	cancel->show() ;
}

void NetDialog::server_clicked()
{
	current_state = SERVER ;
	show_serverclient( SERVER ) ;
	ok->setText( i18n("Connect") ) ;
	info->setText( i18n("Server mode") ) ;
}

void NetDialog::client_clicked()
{
	current_state = CLIENT ;
	show_serverclient( CLIENT ) ;
	ok->setText( i18n("Connect") ) ;
	info->setText( i18n("Client mode") ) ;
}

void NetDialog::server_start()
{
	//debug("server_start()") ;

	int p = port->value() ;
	server = new KServerSocket( p ) ;
	current_state = SERVER_LISTENING ;
	connect( server, SIGNAL(accepted(KSocket*)),
		this, SLOT( acceptSocket(KSocket*)) ) ; 

	ok->hide() ;
	info->setText( i18n("Waiting for client to connect." ) ) ;
}

void NetDialog::server_end()
{
	if ( server!=0 )
	{
		delete server ;
		server=0 ; 
	}

	if ( client!=0 )
	{
		delete client ;
		client=0 ; 
	}
}

void NetDialog::client_start()
{
	int p = port->value() ;
	const char *a = address->text() ;

	printf("trying to make connection to: %s %d\n",
		a, p ) ;

	if (client!=0)
		delete client ;

	client = new KSocket( a, p ) ;
	if ( client->socket() > -1 )
	{
		ok->hide() ;
		info->setText( i18n("Waiting for server to start game") ) ;
		// connection made
		acceptSocket( client ) ;
	}
	else
	{
		info->setText( i18n("Connection to server failed.\n"
			"Click on 'Connect' to try again.") ) ; 
	}
}

void NetDialog::client_end()
{
	/* at the moment this is unreachable code */
	if ( client!=0 )
	{
		delete client ;
		client=0 ; 
	}
}

void NetDialog::acceptSocket( KSocket *s )
{
	debug("acceptSocket()") ;

	//debug("acceptSocket()") ;

	switch( current_state )
	{
		case SERVER_LISTENING:
			current_state=SERVER_CONNECTED ;
			client = s ;
			info->setText( i18n(
			"Made connection with client." )
				) ;
			ok->setText( i18n("Play !") ) ;
			ok->show() ;
			break ;
		case CLIENT:
			current_state=CLIENT_CONNECTED ;
			netobject = new KNetObject( client ) ;
			accept() ; 
			break ;
		default:
			debug("internal error - report to pte@ddsw.nl") ;
			break ;
	}
}

void NetDialog::ok_clicked()
{
	switch( current_state )
	{
		case CHOOSE_MODE:
				break ;
		case SERVER:
				server_start() ;
				break;
		case CLIENT:
				client_start() ;
				break;
		case SERVER_LISTENING:
				break;
		case SERVER_CONNECTED:
				netobject = new KNetObject( client ) ;
				accept() ; 
				break ;

		default:	debug("error") ;
				break ;
	}
}

void NetDialog::reject()
{
	switch( current_state )
	{
		case CHOOSE_MODE:
			QDialog::reject() ;
			break ;
		case SERVER:
			choose_mode() ;
			break ;
		case CLIENT:
			choose_mode() ;
			break ;
		case SERVER_LISTENING:
		case SERVER_CONNECTED:
			server_end() ;
			choose_mode() ;
			break ;
		case CLIENT_CONNECTED:
			client_end() ;
			choose_mode() ;
			break ;
		default:	
			break ;
	}
}

