#include <kgreditfield.h>
#include <kgreditfield.moc>

kgreditField::kgreditField(int id, int x, int y, QWidget *parent, const char * name)
  :QWidget(parent,name)
{
  KIconLoader *loader = kapp->getIconLoader();
  
  myid = id; 
  x_pos = x;
  y_pos = y;

  object_id=FREE;
  object_tmp=0;

  mouse_pressed = false;
  
  fixpix = QPixmap(16,16);
  tmppix = QPixmap(16,16);
  bgpix = loader->loadIcon("hgbrick.xpm",16,16);
  fixpix = bgpix;

  setAcceptDrops (true);

  setFixedSize(fieldw,fieldh);
  move(x_pos,y_pos);
  setBackgroundPixmap(bgpix);
}

kgreditField::~kgreditField()
{
}


void kgreditField :: mousePressEvent(QMouseEvent * ev)
{
  setPressedStatus(true);
  getActiveObject(myid);
  getActivePix(myid);
  if (object_tmp == object_id)
    {
      fixpix = bgpix;
      object_id = FREE;
    } else {
      fixpix = tmppix;
      object_id = object_tmp;
    }
}

void kgreditField :: mouseReleaseEvent(QMouseEvent * ev)
{
  setPressedStatus(false);
}

void kgreditField :: enterEvent(QEvent * ev)
{

  getActiveObject(myid);
  if (object_id == object_tmp) // genau dieses Object liegt hier
    {      
      tmppix =  bgpix;
      object_tmp = FREE;
    } else {
      getActivePix(myid);
    }
  getPressedStatus(myid);
  if (mouse_pressed)
    {
      fixpix = tmppix;
      object_id = object_id;
    } 
  setBackgroundPixmap(tmppix);
  }

void kgreditField :: leaveEvent(QEvent * ev)
{
  setBackgroundPixmap(fixpix);
}

void kgreditField :: setActivePixmap(QPixmap &pix)
{// parent bergibt aktuelle Pixmap
  tmppix = pix;
}

void kgreditField :: setActiveObject(unsigned char obj)
{// parent bergibt aktuelle Objekt_ID
  object_tmp = obj;
}

void kgreditField :: clean()
{
  object_id=FREE;
  setBackgroundPixmap(bgpix);
  fixpix = bgpix;
}

void kgreditField :: setObject(unsigned char obj)
{// parent bergibt die geladene Objektid
  object_id = obj;
}

unsigned char kgreditField::getObject()
{
  return object_id;
}

void kgreditField :: setPixmap(QPixmap &pix)
{// parent bergibt das geladene Pixmap
  fixpix = pix;
  setBackgroundPixmap(pix);
}

void kgreditField :: setMousePressStatus(bool set)
{// parent bergibt den Mausstatus
  mouse_pressed = set;
}


