#include <playfield.h>
#include <kjewel.h>
#include <kapp.h>
#include <qfont.h>
#include <qcolor.h>
#include <qlcdnumber.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>
#include <previewfield.h>
#include <highscorelist.h>
#include <jewel.h>
#include <stdio.h>
/*
QPixmap Jewel::jewelPixmaps[8]={
  QPixmap("/home/bk/gfx/jewels/any_j.gif"),
  QPixmap("/home/bk/gfx/jewels/red_j.gif"),
  QPixmap("/home/bk/gfx/jewels/blue_j.gif"),
  QPixmap("/home/bk/gfx/jewels/green_j.gif"),
  QPixmap("/home/bk/gfx/jewels/yellow_j.gif"),
  QPixmap("/home/bk/gfx/jewels/malve_j.gif"),
  QPixmap("/home/bk/gfx/jewels/sea_j.gif")
};
*/
void KJewelMainWidget::createMenu()
{
  int id;

  file = new QPopupMenu();
  id = file->insertItem(klocale->translate("&New game"),
			playfield, SLOT(startPauseGame()));
  //  accel->changeMenuAccel(file, id, KAccel::New );
  id = file->insertItem(klocale->translate("&Quit"),
				this, SLOT(quitapp()) );
  help = kapp->getHelpMenu( true, about() ) ;

  menu = new KMenuBar(this, "menu");
  menu->insertItem(klocale->translate("&File"), file, 5);
  menu->insertSeparator(-1);
  menu->insertItem(klocale->translate("&Help"), help);

  setMenu(menu);
}

void KJewelMainWidget::helpmenu()
{
	KApplication::getKApplication()->invokeHTMLHelp("","");
}
const char* KJewelMainWidget::about()
{
  QString *tmp = new QString() ;
  tmp->sprintf( "%s %s %s\n", "kjewel", VERSION, DATE ) ;
  tmp->append( klocale->translate(
       "\nA program written in C++ using Qt/Kde.\n"
       "Based on the Game xjewel. \n\n"
       "Written by Birger Koblitz <koblitz@heh.uni-kiel.de>" )
	       );
  return tmp->data() ;
}

void KJewelMainWidget::keyPressEvent(QKeyEvent *e){
  playfield->keyPressed(e);
}

void KJewelMainWidget::quitapp(){
  app->quit();
}

KJewelMainWidget::KJewelMainWidget(KApplication *a)
{
  app=a;
  
  QLCDNumber *scoreDisplay;

  QPushButton *quit, *start, *highscore_b;
  Highscorelist *highscores;
  
  QRadioButton *b1,*b2,*b3;
  QButtonGroup *bg;
  Previewfield *previewfield;

  resize(484,580);
  
  quit = new QPushButton( "Quit", this );
  quit->move( 5, 40 );
  quit->resize( 70, 22 );
  quit->setFont( QFont( "Times", 12, QFont::Bold ) );

  start = new QPushButton( "Start", this );
  start->move( 5, 80 );
  start->resize(70 , 22 );
  start->setFont( QFont( "Times", 12, QFont::Bold ) );
  
  highscores=new Highscorelist();

  highscore_b= new QPushButton( "Highscores", this );
  highscore_b->move( 5, 120 );
  highscore_b->resize( 70, 22 );
  highscore_b->setFont( QFont( "Times", 12, QFont::Bold ) );

  playfield = new Playfield(this,"Playfield",0,start,highscores,
			    app->kde_datadir());
  playfield->resize(224+6,544);
  playfield->move(80,40);
  playfield->setBackgroundColor(QColor(0,0,0));
  playfield->kdedir=app->kde_datadir();

  scoreDisplay=new QLCDNumber(7,this,"scoreDisplay");
  scoreDisplay->move(260+84,140);
  scoreDisplay->resize(80,30);
  
  b1 = new QRadioButton("Easy",this, "b1");
  b1->setMinimumSize( b1->sizeHint() );
  b1->move( 5,200 );
  b1->resize( 55, 20 );
  b1->setMaximumSize( 500, b1->minimumSize().height() );
  b2 = new QRadioButton("Normal",this, "b2");
  b2->move( 5,220 );
  b2->resize( 55, 20 );
  b2->setMinimumSize( b2->sizeHint() );
  b2->setMaximumSize( 500, b2->minimumSize().height() );
  b3 = new QRadioButton("Hard",this, "b3");
  b3->setMinimumSize( b3->sizeHint() );
  b3->setMaximumSize( 500, b3->minimumSize().height() );
  b3->move( 5,240 );
  b3->resize( 55, 20 );

  bg = new QButtonGroup();
  bg->insert( b1 );
  bg->insert( b2 );
  bg->insert( b3 );

  previewfield=new Previewfield(this,playfield);
  previewfield->resize(32+4,3*32+4);
  previewfield->move(384,40);
  previewfield->setBackgroundColor(QColor(0,0,0));

  QObject::connect( quit, SIGNAL(clicked()), this, SLOT(quitapp()) );
  QObject::connect( start, SIGNAL(clicked()),
		    playfield, SLOT(startPauseGame()) );
  QObject::connect( bg, SIGNAL(clicked(int)),
		    playfield, SLOT(notifyDifficulty(int)) );
  QObject::connect( playfield, SIGNAL(changeScore(int)),
		    scoreDisplay, SLOT(display(int)) );
  QObject::connect( highscore_b, SIGNAL(clicked()),
		    playfield, SLOT(showList()) );
  QObject::connect( playfield, SIGNAL(changeRunStatus(bool)),
		    b1, SLOT(setEnabled(bool)) );
  QObject::connect( playfield, SIGNAL(changeRunStatus(bool)),
		    b2, SLOT(setEnabled(bool)) );
  QObject::connect( playfield, SIGNAL(changeRunStatus(bool)),
		    b3, SLOT(setEnabled(bool)) );
  QObject::connect( playfield, SIGNAL(nextJewelChanged()),
		    previewfield, SLOT(updateJewel()) );
  b1->setChecked(TRUE);

  createMenu();
}
int main( int argc, char **argv )
{
  KApplication kjewel( argc, argv,"kjewel" );
  KJewelMainWidget mainWidget(&kjewel);

  kjewel.setMainWidget( &mainWidget );
  mainWidget.setFocusPolicy(QWidget::StrongFocus);
  mainWidget.show();
  return kjewel.exec();
}
