/*
 *   kmamerun - a interface for M.A.M.E
 *   Copyright (C) 1998  Juergen Vigna
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qfiledlg.h> 
#include <qaccel.h> 
#include <qmsgbox.h>
#include <ktopwidget.h>
#include <ktoolbar.h>
#include <kiconloader.h>
#include <kapp.h>
#include <kurl.h>
#include <kstdaccel.h>
#include <ksimpleconfig.h>
#include "mainwidget.h"
#include "kmamerun.h"

//
// DEFINE GLOBAL DATA
//
QString
    debugFlag, globalGameName, globalGameFullName;

MainWidget::MainWidget(char *,QWidget *, const char *name)
	: KTopLevelWidget(name)
{
    QString
        cap;
    int
        n;

    kapp->getConfig()->setGroup("kmamerun");
    showToolbar = kapp->getConfig()->readNumEntry("show_toolbar",true);
    sortOrder = kapp->getConfig()->readNumEntry("sort_order",ID_SO_NAMEFULL);
    showFlag = kapp->getConfig()->readNumEntry("show_flag",ID_SH_ALL);
    initMenu();
    kmamerun_widget = new KMameRun(this, 0, showFlag - ID_SH_ALL,
                                   sortOrder - ID_SO_NAME);
    connect(kmamerun_widget,SIGNAL(gameSelected(const char *, int)),this,
            SLOT(setGamePref(const char *, int)));
    setView(kmamerun_widget);
    kmamerun_widget->show();
    setMinimumSize(kmamerun_widget->minimumSize().width(),
                   kmamerun_widget->minimumSize().height()+
                   toolbar->height() + menu->height());
    setGeometry(x(), y(),kmamerun_widget->width(),
                kmamerun_widget->height()+toolbar->height()+menu->height());
    setMinimumSize(kmamerun_widget->minimumSize().width(),
                   kmamerun_widget->totMinimumHeight() +
                   toolbar->height()+menu->height()+10);
    bool x = kapp->getConfig()->readNumEntry("show_logfile",false);
    if (kmamerun_widget->showLogfile != x)
        menuCallback(ID_OP_LOGFILE);
    prefdiag = new Preferences();
    connect(prefdiag,SIGNAL(prefHide()),this,SLOT(preferencesHide()));
    connect(prefdiag,SIGNAL(commitChanges()),this, SLOT(updateConfig()));
    connect(prefdiag,SIGNAL(prefGameChanged()),this, SLOT(updateListbox()));
    n=kmamerun_widget->reloadListbox(showFlag - ID_SH_ALL);
    cap.sprintf("KMameRun (%d)",n);
    setCaption(cap);
}

MainWidget::~MainWidget()
{
}

int MainWidget::initMenu() {

    QPopupMenu *file = new QPopupMenu;
    file->insertItem(i18n("&Run Game"), ID_FILE_RUN);
    file->insertSeparator();
    file->insertItem(i18n("&Quit"), ID_FILE_QUIT);
    file->setAccel(CTRL+Key_Q, ID_FILE_QUIT);
    
    mshow = new QPopupMenu;
    mshow->setCheckable(true);
    mshow->insertItem(i18n("&All"), ID_SH_ALL);
    mshow->insertItem(i18n("A&vailable"), ID_SH_AVAILABLE);
    mshow->insertItem(i18n("&Not available"), ID_SH_NOTAVAILABLE);
    mshow->setItemChecked(showFlag,true);

    msort = new QPopupMenu;
    msort->setCheckable(true);
    msort->insertItem(i18n("&Name"), ID_SO_NAME);
    msort->insertItem(i18n("&Full Name"), ID_SO_NAMEFULL);
    msort->insertItem(i18n("&Type"), ID_SO_TYPE);
    msort->insertItem(i18n("&Priority"), ID_SO_PRIORITY);
    msort->setItemChecked(sortOrder,true);

    moptions = new QPopupMenu;
    moptions->setCheckable(true);
    moptions->insertItem(i18n("&Preferences"), ID_OP_PREF);
    moptions->insertItem(i18n("&Toggle Toolbar"), ID_OP_TOOLBAR);
    moptions->insertItem(i18n("Toggle &Log"), ID_OP_LOGFILE);

    QPopupMenu *help = new QPopupMenu;
    help->insertItem(i18n("&Help"), ID_HELP_HELP);
    help->setAccel(Key_F1, ID_HELP_HELP);
    help->insertSeparator();
    help->insertItem(i18n("&About"), ID_HELP_ABOUT);

    menu = new KMenuBar(this);
    menu->insertItem(i18n("&File"), file);
    menu->insertItem(i18n("Sho&w"), mshow);
    menu->insertItem(i18n("&Sort"), msort);
    menu->insertItem(i18n("&Options"), moptions);
    menu->insertSeparator();
    menu->insertItem(i18n("&Help"), help);

    menu->show();
    setMenu(menu);
    
    connect (menu, SIGNAL (activated (int)), SLOT(menuCallback (int)));

    KIconLoader *loader = kapp->getIconLoader();
    toolbar = new KToolBar(this);
    
    toolbar->insertButton(loader->loadIcon("exit.xpm"),ID_FILE_QUIT, TRUE,
                          i18n("Quit"));
    toolbar->insertButton(loader->loadIcon("send.xpm"),ID_FILE_RUN, TRUE,
                          i18n("Run Game"));
    addToolBar(toolbar);
    toolbar->setBarPos(KToolBar::Top);
    toolbar->show();
    moptions->setItemChecked(ID_OP_TOOLBAR,showToolbar);
    if (!showToolbar)
        enableToolBar();
    connect(toolbar, SIGNAL(clicked(int)), this, SLOT(menuCallback(int)));
    updateRects();
    return 0;
}

void MainWidget::menuCallback(int item)
{
    QString
        aConfigName = KApplication::localconfigdir() + "/kmamerunrc";
    KSimpleConfig
        config(aConfigName);
    config.setGroup("kmamerun");

    switch(item) {
      case ID_FILE_RUN: {
          kmamerun_widget->RunGame();
          break;
      }
      case ID_FILE_QUIT: {
          kapp->exit();
          break;
      }
      case ID_SH_ALL:
      case ID_SH_AVAILABLE:
      case ID_SH_NOTAVAILABLE:
          if (showFlag != item) {
              int n;
              QString cap;
              mshow->setItemChecked(showFlag,false);
              showFlag = item;
              mshow->setItemChecked(showFlag,true);
              n=kmamerun_widget->reloadListbox(item - ID_SH_ALL);
              cap.sprintf("KMameRun (%d)",n);
              setCaption(cap);
              if (showFlag != ID_SH_ALL)
                  config.writeEntry("show_flag",showFlag);
              else
                  config.deleteEntry("show_flag", false);
          }
          break;
      case ID_SO_NAME:
      case ID_SO_NAMEFULL:
      case ID_SO_TYPE:
      case ID_SO_PRIORITY:
          msort->setItemChecked(sortOrder,false);
          sortOrder = item;
          msort->setItemChecked(sortOrder,true);
          kmamerun_widget->setSortMode(item - ID_SO_NAME);
          if (sortOrder != ID_SO_NAMEFULL)
              config.writeEntry("sort_order",sortOrder);
          else
              config.deleteEntry("sort_order", false);
          break;
      case ID_OP_PREF: {
          if (prefdiag->isVisible())
              break;
          prefdiag->readConfig();
          prefdiag->show();
          mamecmd = prefdiag->prefGeneral.mamecmd.copy();
          break;
      }
      case ID_OP_TOOLBAR: {
          enableToolBar();
          showToolbar = !showToolbar;
          moptions->setItemChecked(ID_OP_TOOLBAR,showToolbar);
          config.writeEntry("show_toolbar",showToolbar);
          break;
      }
      case ID_OP_LOGFILE: {
          kmamerun_widget->toggleLogfile();
          moptions->setItemChecked(ID_OP_LOGFILE,kmamerun_widget->showLogfile);
          config.writeEntry("show_logfile",kmamerun_widget->showLogfile);
          break;
      }
      case ID_HELP_HELP: {
          KApplication::getKApplication()->invokeHTMLHelp("", "");
          break;
      }
      case ID_HELP_ABOUT: {
          QMessageBox::about(0,
              i18n("About"),
              i18n("KMameRun " VERSION "\n\nCopyright 1998\n"
                   "by Jrgen Vigna\njug@sad.it"));
          break;
      }
    }
}

void MainWidget::preferencesHide()
{
    if (!prefdiag->isVisible())
        return;
    prefdiag->hide();
}

void MainWidget::updateConfig()
{
    prefdiag->readConfig();
    QString cmd = prefdiag->prefGeneral.mamecmd.copy();

    if (mamecmd != cmd)
        kmamerun_widget->reloadListbox(showFlag,true);
    mamecmd = cmd;
}

void MainWidget::updateListbox()
{
    kmamerun_widget->reloadListbox();
}

void MainWidget::setGamePref(const char *item, int pos)
{
    char
        buf[30];
    
    sscanf(item+pos,"%s",buf);
    globalGameName = buf;
    globalGameName = globalGameName.stripWhiteSpace();
    globalGameFullName = QString(item).mid(0,pos);
    globalGameFullName = globalGameFullName.stripWhiteSpace();
    prefdiag->readConfig();
}
