/*
 *   kmamerun - a interface for M.A.M.E
 *   Copyright (C) 1998  Juergen Vigna
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "prefgame.h"
#include <kapp.h>
#include <ksimpleconfig.h>

#define Inherited PrefGameData

PrefGame::PrefGame(QWidget* parent, const char* name)
	:Inherited( parent, name )
{
    comboType->clear();
    comboType->setAutoResize( TRUE );
    comboType->insertItem(i18n("Action"));
    comboType->insertItem(i18n("Jump&Run"));
    comboType->insertItem(i18n("Shoot'em-up"));
    comboType->insertItem(i18n("Sport"));
    comboType->insertItem(i18n("Education"));
    comboType->insertItem(i18n("Other"));
    labelGameName->setAutoResize( TRUE );
    labelGameName->setText("Pacman");
}

PrefGame::~PrefGame()
{
}

void PrefGame::setPrefs(struct game_prefs *prefs)
{
    checkDefaultOpt->setChecked(prefs->default_opt);
    comboPriority->setCurrentItem(prefs->priority);
    comboType->setCurrentItem(prefs->type);
    labelGameName->setText(prefs->game_full_name);
    oldPriority = prefs->priority;
    oldType = prefs->type;
}

bool PrefGame::writeConfig(struct game_prefs *prefs, const char *cname)
{
    QString
        cgroup = cname,
        aConfigName = KApplication::localconfigdir() + "/kmamerunrc";

    cgroup += "Game";
    KSimpleConfig config(aConfigName);
    config.setGroup(cgroup);
    if (prefs->default_opt != checkDefaultOpt->isChecked())
        config.writeEntry("default_opt",checkDefaultOpt->isChecked());
    else
        config.deleteEntry("default_opt", false);
    if (prefs->priority != comboPriority->currentItem())
        config.writeEntry("priority",comboPriority->currentItem());
    else
        config.deleteEntry("priority", false);
    if (prefs->type != comboType->currentItem())
        config.writeEntry("type",comboType->currentItem());
    else
        config.deleteEntry("type", false);
    if ((oldPriority != comboPriority->currentItem()) ||
        (oldType != comboType->currentItem()))
        return true;
    return false;
}

void PrefGame::readConfig(struct game_prefs *prefs, const char *cname)
{
    QString
        cgroup = cname,
        aConfigName = KApplication::localconfigdir() + "/kmamerunrc";

    cgroup += "Game";
    KSimpleConfig config(aConfigName);
    config.setGroup(cgroup);
    if (config.hasKey("default_opt"))
        prefs->default_opt = config.readNumEntry("default_opt");
    if (config.hasKey("priority"))
        prefs->priority = config.readNumEntry("priority");
    if (config.hasKey("type"))
        prefs->type = config.readNumEntry("type");
}

bool PrefGame::useDefaultOpt()
{
    return checkDefaultOpt->isChecked();
}
