/*
 *   kmamerun - a interface for M.A.M.E
 *   Copyright (C) 1998  Juergen Vigna
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef PrefVideo_included
#define PrefVideo_included

#include "prefvideodata.h"

struct video_prefs {
    QString display;
    int heightscale;
    int widthscale;
    int frameskip;
    bool use_xsync;
    bool use_dirty;
    bool use_mitshm;
    bool private_colormap;
    bool force_truecolor;
    bool throttle;
    // local parameters
    bool rotation;
    bool ror90;
    bool rol90;
    bool flip_Xaxis;
    bool flip_Yaxis;
};

class PrefVideo : public PrefVideoData
{
    Q_OBJECT

public:
    PrefVideo(QWidget* parent = NULL,const char* name = NULL);
    virtual ~PrefVideo();
    void setPrefs(struct video_prefs *prefs);
    void writeConfig(struct video_prefs *prefs, const char *cname);
    void readConfig(struct video_prefs *prefs, const char *cname);
    const QString optionString(struct video_prefs *prefs, const char *cname);
};
#endif // PrefVideo_included
