/***************************************************************************
                          cmudstream.h
                      -------------------
    description          : Class for wrapping telnet I/O
    begin                : Wed Dec 22 1999
    copyright            : (C) 1999 by Stephan Uhlmann
                                       Andre Alexander Bell
    email                : suhlmann@gmx.de
                           andre.bell@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef CMUDSTREAM_H
#define CMUDSTREAM_H

#include <qstack.h>

#include "resource.h"
#include "ctelnet.h"
#include "kmudview.h"
#include "kmuddoc.h"
#include "cmudlog.h"
#include "ccharacterprofile.h"
#include "qdatetime.h"
#ifdef MAPPER
#include "cmapwindow.h"
#endif

class KmudApp;
class CPluginManager;

/**
  *@author Stephan Uhlmann, Andre Alexander Bell
  * This class is for wrapping telnet I/O on order to have a centralized
  * place for processing/filtering these data
  */

class CMudStream : public QObject {
 Q_OBJECT

public:
	/** constructor */
	CMudStream(KmudApp* app);
	/** destructor */
	~CMudStream();

	/** set the entry for the current connected mud. Should be set to NULL
	    when not connected */
	void setCharDBEntry(CharDBEntry *e);


#ifdef MAPPER
	/** sets the pointer to the mapper */
	void setMapper (CMapWindow *map);
#endif
	/** reset's the autologin */
	void reset ();


public slots:
	/** slot processing input to the mud */
	void slotProcessInput(QString);
	/** slot processing output from the mud */
	void slotProcessOutput(QString);

signals:
	/** emitted when input was processed */
	void processedInput();
	/** emitted when output was processed */
	void processedOutput();

private:

	KmudApp* kmudapp;

	CPluginManager* pluginmanager;

	/** Try to automagically log in */
	void autologin(QString output);

	/** telnet connection */
	CTelnet* connection;

	/** pinter to the Char DB entry */
	CharDBEntry *entry;
	/** pointers to the I/O processing classes */
	KmudView* view;
	/** the document */
	KmudDoc* doc;
	/** the log */
	CMudLog* log;
#ifdef MAPPER
	/** The auto mapper */
	CMapWindow* mapper;
	/** The stack to hold directions so that then can be check to see if
	    They are a valid move */
	QStack<direction> directionList;
#endif

	////Filters////
	///////////////
	/** proccess speedwalking */
	void inSpdWalk(QString&, QString);
	/** proccess backslashes */
	void inBackslash(QString &);
	/** splits the input into pieces, using the separator-char */
	void inSeparator (QString & input, QString separatorChar);
	/** processes call to external commands */
	void inExternCommand (QString & input, QString externChar);
	/** have we already logged in? */
	bool AutologinFinished;
	/** has the loginname been sent */
	bool LoginHasBeenSent;
	/** has the password been sent */
	bool PasswordHasBeenSent;
};

#endif
