/***************************************************************************
                          dlgoptiontiming.cpp
                      -------------------
    description          :
    begin                : Thu Oct 26 2000
    copyright            : (C) 2000 by Andre Alexander Bell
    email                : andre.bell@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "dlgoptiontiming.h"

DlgOptionTiming::DlgOptionTiming(QWidget *parent, const char *name) : QDialog(parent,name,true)
{
	initDialog();
	connect( autoReconnect_CheckBox, SIGNAL(toggled(bool)), SLOT(slotRefreshEnablesDisables()) );
	connect( outputNotifyBlinkOn_CheckBox, SIGNAL(toggled(bool)), SLOT(slotRefreshEnablesDisables()) );
}

DlgOptionTiming::~DlgOptionTiming()
{
}

bool DlgOptionTiming::getAutoReconnect()
{
	return autoReconnect_CheckBox->isChecked();
}

void DlgOptionTiming::setAutoReconnect(bool b)
{
	autoReconnect_CheckBox->setChecked(b);
}

void DlgOptionTiming::setAutoTime(unsigned int t)
{
	QString s;
	s.setNum(t);
	autoReconnectSeconds_LineEdit->setText(s);	
}

unsigned int DlgOptionTiming::getAutoTime()
{
	QString s = autoReconnectSeconds_LineEdit->text();
	return s.toUInt();
}

void DlgOptionTiming::setOutputNotifyOn(bool b)
{
	outputNotifyBlinkOn_CheckBox->setChecked(b);
}

bool DlgOptionTiming::getOutputNotifyOn()
{
	return outputNotifyBlinkOn_CheckBox->isChecked();
}

void DlgOptionTiming::setOutputNotifySeconds(unsigned int sec)
{
	QString s;
	s.setNum(sec);
	outputNotifySeconds_LineEdit->setText(s);
}

unsigned int DlgOptionTiming::getOutputNotifySeconds()
{
	QString s = outputNotifySeconds_LineEdit->text();
	return s.toUInt();
}

unsigned int DlgOptionTiming::getConnectTimeoutSeconds()
{
	QString s = connectTimeoutSeconds_LineEdit->text();
	return s.toUInt();
}

void DlgOptionTiming::setConnectTimeoutSeconds(unsigned int t)
{
	QString s;
	s.setNum(t);
	connectTimeoutSeconds_LineEdit->setText(s);
}

void DlgOptionTiming::slotRefreshEnablesDisables()
{
	if (autoReconnect_CheckBox->isChecked())
		autoReconnectSeconds_LineEdit->setEnabled(true);
	else autoReconnectSeconds_LineEdit->setEnabled(false);

	if (outputNotifyBlinkOn_CheckBox->isChecked())
		outputNotifySeconds_LineEdit->setEnabled(true);
	else outputNotifySeconds_LineEdit->setEnabled(false);
}
