/***************************************************************************
                          dlgselectprofile.cpp
                      -------------------
    description          :
    begin                : Sun Nov 14 1999
    copyright            : (C) 1999 by Stephan Uhlmann                         
    email                : suhlmann@gmx.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "dlgselectprofile.h"

#define noprofile QString("<")+i18n("none")+QString(">")

DlgSelectProfile::DlgSelectProfile(KmudDoc* document, QWidget *parent, const char *name) : QDialog(parent,name,true){
	
	setCaption(i18n("Select Profile"));
	
	CCharacterProfile* prof;
	QFileInfo fi;

	initDialog();

	doc = document;

	filenames.setAutoDelete(true);
	filenames.clear();

	filenames.append(noprofile);
	profile_ListBox->insertItem(noprofile);


	prof=doc->firstProf();
	while (prof!=NULL)
	{
		fi.setFile("",prof->getFileName());
		profile_ListBox->insertItem(fi.baseName());
		filenames.append(prof->getFileName());
		prof=doc->nextProf();
	}


	connect( ok_Button, SIGNAL(clicked()), SLOT(accept()) );
	connect( cancel_Button, SIGNAL(clicked()), SLOT(reject()) );
	connect( profile_ListBox, SIGNAL(selected(int)), SLOT(accept()) );

	if (profile_ListBox->count() >= 1 ) profile_ListBox->setSelected(0,true);

}

DlgSelectProfile::~DlgSelectProfile(){
}


CCharacterProfile* DlgSelectProfile::getSelectedProfile()
{
	QString s;
	CCharacterProfile* prof;

	s=filenames.at(profile_ListBox->currentItem());
	if (s == noprofile) prof=NULL;
		else prof = doc->getCharacterProfile(s);

	return prof;
}