/***************************************************************************
                          kmuddoc.h
                        -------------------
    description          : Document Class (Character Database)
    begin                : Sun Jun 20 14:17:54 MEST 1999
    copyright            : (C) 1999 by Stephan Uhlmann
    email                : suhlmann@gmx.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KMUDDOC_H
#define KMUDDOC_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <qobject.h>
#include <qlist.h>
#include <qdir.h>
#include <ksimpleconfig.h>

#include "ccharacterprofile.h"
#include "cmudprofile.h"

/** Struct storing one entry in the character database */
struct CharDBEntry
{
	QString ID;
	QString login;
	QString password; /* password for the loginname */

	QString profile;
	QString mudfile;
};


/**
  * This class provides the Kmud document
  *@author Stephan Uhlmann
  */
class KmudDoc : public QObject
{
  Q_OBJECT

 public:
	/** Constructor for the fileclass of the application */
	KmudDoc(QObject*, const char *filename=0);
	/** Destructor for the fileclass of the application */
	~KmudDoc();

	/** inserts an entry with the given data to the database inserts the 
	  * characterprofile and the mudprofile only if not in list already
	  */
	void insertEntry(QString ID, QString login, QString password, CCharacterProfile* prof, CMudProfile* mud);

	/** deletes all entries with the given id from the database deletes the
	  * accoring characterprofile and the mudprofile only if no other entry
	  * uses them
	  */
	void deleteEntry(QString ID);

	/** makes the first item in list current and
	  * returns a pointer to it or NULL if list is empty
	  */
	CharDBEntry* first();

	/** makes succseeding item in list current and returns a pointer to it 
	  * or NULL if current item was the last or list is empty
	  */
	CharDBEntry* next();

	/** returns a pointer to the current item or NULL if list is empty */
	CharDBEntry* current();

	/** returns a pointer to the matching item or NULL if not in list */
	CharDBEntry* getEntry(QString login,QString mudTitle);

	/** returns a pointer to the matching item or NULL if not in list */
	CharDBEntry* getEntry(QString ID);

	/** returns the character profile with the given character ID or NULL 
	  * if not in list
	  */
	CCharacterProfile* getCharacterProfile(QString filename);

	/** returns the mud profile with the given mud ID
	  * or NULL if not in list
	  */
	CMudProfile* getMudProfile(QString filename);

	/** inserts character profile to list if not in list, returns position in list */
	int insertCharacterProfile(CCharacterProfile* cp);
	/** deletes character profile from list*/
	void deleteCharacterProfile(CCharacterProfile* cp);

	/** inserts mud profile to list if not in list, returns position in list */
	int insertMudProfile(CMudProfile* mp);
	/** deletes mud profile from list*/
	void deleteMudProfile(CMudProfile* mp);


	/** reads character database from the local kde-dir */
	void readCharDB();
	/** writes character database to the local kde-dir */
	void writeCharDB();

	/** reads all profiles from local kde-dir to list */
	void readProfs();
	/** writes all profiles from list to local kde-dir */
	void writeProfs();

	/** reads all muds from local kde-dir to list */
	void readMuds();
	/** writes all muds from list to local kde-dir */
	void writeMuds();

	CCharacterProfile* firstProf();
	CCharacterProfile* nextProf();
	CCharacterProfile* currentProf();
	unsigned int numProfs();

	CMudProfile* firstMud();
	CMudProfile* nextMud();
	CMudProfile* currentMud();
	unsigned int numMuds();


	/** returns ID of the character profile that is currently set */
	QString getCurrentCharacterID();
	/** returns ID of the mud profile that is currently set */
	QString getCurrentMudID();

	/** sets ID of the character profile that is currently set */
	void setCurrentCharacterID(QString);
	/** sets ID of the mud profile that is currently set */
	void setCurrentMudID(QString);
  /** decodes the password */
  QString decodePassword(QString pw);
  /** applies "encryption" on the password */
  QString encodePassword(QString pw);
  /** the intelligentHistoryFlag will be set */
  void setIntelligentHistory(bool i);
  /** if the history should react intelligent returns it TRUE */
  bool getIntelligentHistory();

 private:

	QList<CharDBEntry> db;
	QList<CCharacterProfile> profs;
	QList<CMudProfile> muds;

	int currentIndex;
	int currentProfIndex;
	int currentMudIndex;

	/** ID of the character profile that is currently set */
	QString currentCharacterID;
	/** ID of the mud profile that is currently set */
	QString currentMudID;
  /** works the browsing in the history intelligent? */
  bool intelligentHistory;


};

#endif // KMUDDOC_H
