#ifndef REFEREE_H
#define REFEREE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapp.h>
#include <qwidget.h>
#include <qlist.h>
#include <qstrlist.h>
#include <qarray.h>
#include <qbitarry.h>

#include "board.h"
#include "pacman.h"
#include "monster.h"
#include "fruit.h"
#include "bitfont.h"
#include "painter.h"

enum { Init, Introducing, Playing, Demonstration, Paused, Player, Ready, 
       Scoring, LevelDone, Dying, GameOver, HallOfFame };


class Referee : public QWidget
{
    Q_OBJECT
public:
    Referee (QWidget *parent=0, const char *name=0, Bitfont *font=0, QString pixDir=0);

    void setSkill(int);
    void setRoom(int);

public slots:
    void setFont(Bitfont *font=0);
    void setPixmaps(QString pixDir=0);

    void levelUp();
    void levelUpPlay();

    void pause();
    void ready();
    void intro();
    void introPlay();
    void hallOfFame();
    void demo();
    void play();
    void killed();
    void killedPlay();
    void eaten();
    void toggleHallOfFame();

    void initKeys();
    void initTiming();
    void initScoring();

    void repaintFigures();
    void reloadRoomPixmap();

private slots:
    void start();
    void stop();

signals:
    void setScore(int, int);
    void setPoints(int);
    void setLevel(int);
    void setLifes(int);

    void toggleNew();
    void togglePaused();
    void forcedHallOfFame(bool);

protected:
    void timerEvent( QTimerEvent * );
    void paintEvent( QPaintEvent * );
    void keyPressEvent( QKeyEvent * );
    void focusOutEvent( QFocusEvent * ) { ; }
    void focusInEvent( QFocusEvent * )  { ; }
    void fillArray(QArray<int> &, QString, int);
    void fillStringArray(QStrList &, QArray<int> &);

private:
    QBitArray gameState;
    int timerCount;
    int maxLevel;

    QArray<int> speed;
    QArray<int> monsterIQ;
    QArray<int> pacmanTicks;
    QArray<int> remTicks;
    QArray<int> dangerousTicks;
    QArray<int> harmlessTicks;
    QArray<int> harmlessDurTicks;
    QArray<int> harmlessWarnTicks;
    QArray<int> arrestTicks;
    QArray<int> arrestDurTicks;
    QArray<int> fruitAppearsTicks;
    QArray<int> fruitDurTicks;
    QArray<int> fruitScoreDurTicks;

    int monsterScoreDurMS;
    int playerDurMS;
    int readyDurMS;
    int gameOverDurMS;
    int afterPauseMS;
    int dyingPreAnimationMS;
    int dyingAnimationMS;
    int dyingPostAnimationMS;
    int introAnimationMS;
    int introPostAnimationMS;
    int levelUpPreAnimationMS;
    int levelUpAnimationMS;

    int pointScore;
    int switchScore;
    QArray<int> fruitScore;
    QStrList fruitScoreString;
    QArray<int> monsterScore;
    QStrList monsterScoreString;
    int extraLifeScore;

    int monstersEaten;
    int points;
    int lifes;
    int level;

    Board   *board;
    Painter *pix;
    Pacman  *pacman;
    Fruit   *fruit;

    QList<Monster> *monsters;
    QList<QRect> *monsterRect;

    QRect pacmanRect;
    QRect fruitRect;

    void introMonster(int id);
    void introPaint(int t);

    void initMonsters();
    void initPacman();
    void initFruit();

    int  gameTimer;
    void start(int);
    void init(bool);

    void score(int);

    uint UpKey;
    uint DownKey;
    uint RightKey;
    uint LeftKey;
};

#endif // REFEREE_H
