/* Originally written for kexample (C) 1998 Matthias Ettrich
 * Modified for KPipe
 */
#include "kpipe.h"

#include <qkeycode.h>
#include <kiconloader.h>

KPipe::KPipe()
{
	setMinimumSize(600,580);
	
	view = new KPipeWidget(this);

	// tell the KTMainWindow that this is indeed the main widget
	setView(view);

	// create a DropZone over the entire window and connect it
	// to the slotDropEvent

	/*connect(new KDNDDropZone(this , DndURL), 
	        SIGNAL(dropAction(KDNDDropZone *)), 
	        SLOT(slotDropEvent(KDNDDropZone *)));*/

	//connect(this,SIGNAL(newGame()),view,SLOT(newGame()));


	//---------------------------------------------------
	// build a menubar

	// a menubar consists of popup menus. So we need a 
	// popup menu first
	QPopupMenu* p = new QPopupMenu;
	p->insertItem(i18n("&New Game"),view,SLOT(newGame()), Key_F2);
	p->insertSeparator();
	p->insertItem(i18n("&Highscores..."), view, SLOT(showHighscores()));
	p->insertSeparator();
	p->insertItem(i18n("&Quit"), kapp, SLOT(quit()), CTRL+Key_Q);
	

	// put the popupmenu as File-menu into the menu bar
	menuBar()->insertItem(i18n("&File"), p);

	QPopupMenu *fl = new QPopupMenu();

	fl->insertItem(i18n("&Oil"),view, SLOT(oil()));
	fl->insertItem(i18n("&Water"),view, SLOT(water()));
	fl->insertItem(i18n("&Toxic acid"),view, SLOT(acid()));

	p=new QPopupMenu;
	p->insertItem(i18n("&Beginner"),view, SLOT(beginner()));
	p->insertItem(i18n("&Advanced"),view, SLOT(advanced()));
	p->insertItem(i18n("&Expert"),view, SLOT(expert()));
	p->insertSeparator();
	p->insertItem(i18n("Transport"),fl);
	menuBar()->insertItem(i18n("&Options"),p);

	menuBar()->insertSeparator();

	// we let KDE generate a nifty help menu
	p = kapp->getHelpMenu(false, 
			i18n("KPipe 0.1 -- KDE Pipe Mania!\n\n"
			     "(c) GPL 1998 Sven Knzler (sk@xgm.de)\n"
			     "Score board from Nicolas Hadaceks KTetris\n"
			     ));
	menuBar()->insertItem(i18n("&Help"), p);

	//---------------------------------------------------
	// build a small toolbar

	// insert some buttons, the icons are from the standard KDE toolbar.
	// toolBar()->insertButton(Icon("exit.xpm"),TOOLBAR_EXIT, true,i18n("Exit"));

	// Hint: toolBar() returns toolBar(0). If you want another toolbar, simply
	//       use toolBar(1), toolBar(2) and so on.

	// we connect the entire toolbar to one single slot. We could also
	// connect the single toolbar buttons to special slots in the 
	// insertButton call above, for example:
	//   insertButton(Icon("exit.xpm"),TOOLBAR_EXIT, 
	//                SIGNAL(clicked()), kapp, SLOT(quit()),
	//                true,"Exit")
	// This would be even better for this simple toolbar. We have chosen
	// the other design --- which is more flexible for bigger toolbars ---
	// for demonstration purposes in kless.

	//connect(toolBar(), SIGNAL(clicked(int)), SLOT(slotToolbarClicked(int)));

	enableStatusBar();
	view->show();
}

KPipe::~KPipe()
{
}

void KPipe::slotToolbarClicked(int item)
{
	switch (item)
	{
		case TOOLBAR_EXIT:
			kapp->quit();
			break;
	}
}

void KPipe::slotDropEvent(KDNDDropZone *zone)
{
  // the user dropped something on our window.
  // handle it
  QString u = zone->getURLList().first();
}
