
// -*- c++ -*-

#ifndef STATUS_H
#define STATUS_H

#include <kcontainer.h>
#include <kconfig.h>
#include <qmlined.h>
#include <qvector.h>
#include <qpushbutton.h>
#include <qlcdnumber.h> 
#include "constants.h"
#include "pbutton.h"

class Status : public QWidget
{
  Q_OBJECT

public:
  Status(QWidget *parent, const char *name);

  ~Status();
  QLCDNumber *timeLCD;
  void showHighscores();

 public slots:
  void linkRequired();
  void gameStarted();
  void scoreChanged(int);
  void gameOver();

 private slots:
    void buttonClicked();

signals:
  void nextLink(PipeButton::LinkType);

private:
  bool inGame,isConfigWritable;
  QLCDNumber *scoreLCD;
  PipeButton *preview[5];
  KConfig *kconf;


  PipeButton::LinkType randLink();
  void closeEvent(QCloseEvent *e);
  int exit();
};

#endif // status.h




