#include <kapp.h>
#include "krestoredlg.h"

KRestoreDlg::KRestoreDlg(const char *fn, QWidget *parent, const char *name)
:QDialog(parent,name,true)
{
  initDialog();
  current=0;
  connect(ok, SIGNAL(clicked()), SLOT(accept()));
  connect(cancel, SIGNAL(clicked()), SLOT(reject()));
  connect(radio1, SIGNAL(clicked()), SLOT(radio1sl()));
  connect(radio2, SIGNAL(clicked()), SLOT(radio2sl()));
  connect(radio3, SIGNAL(clicked()), SLOT(radio3sl()));
  radio1->setFocus();
  setCaption(QString(i18n("Restore: "))+fn);
}

KRestoreDlg::~KRestoreDlg()
{
}

void KRestoreDlg::setLabel(const char *label)
{
  QFont font=QLabel_1->font();
  font.setBold(true);
  QLabel_1->setFont(font);
  QLabel_1->setText(label);
  radio2sl();
  radio1->setEnabled(false);
}

void KRestoreDlg::slotfunc(int i)
{
  current=i;
  radio1->setChecked(i==0);
  radio2->setChecked(i==1);
  radio3->setChecked(i==2);
  if (i==0) radio1->setFocus();
    else if (i==1) radio2->setFocus(); else radio3->setFocus();
}

void KRestoreDlg::radio1sl(void)
{
  slotfunc(0);
}

void KRestoreDlg::radio2sl(void)
{
  slotfunc(1);
}

void KRestoreDlg::radio3sl(void)
{
  slotfunc(2);
}
