#include <kmsgbox.h>
#include <unistd.h>
#include <fcntl.h>
#include <kapp.h>
#include <qdir.h>
#include "kscore.h"

extern "C" {
char *score_str(const char *name, short m_char, short other, short level, 
  short amulet, int usern);
void turn_into_games();
void turn_into_user();
long xxx(char);
void xxxx(char *, short);
}

KScoreList::KScoreList(int _user)
{
  KConfig *cfg=kapp->getConfig();
  loaded=0;
  curr=0;
  user=_user;
  if (!user)
  {
    cfg->setGroup("Config");
    scorefile=cfg->readEntry("HostScoresFile");
    if (scorefile.isEmpty() || scorefile.isNull())
    {
      scorefile=kapp->kde_datadir();
      scorefile+="/krogue/krogue.scores";
    }
  } else
  {
    scorefile=kapp->localkdedir();
    scorefile+="/share";
    QDir dir(scorefile);
    if (!dir.exists()) dir.mkdir(scorefile);
    scorefile+="/apps";
    dir.setPath(scorefile);
    if (!dir.exists()) dir.mkdir(scorefile);
    scorefile+="/krogue";
    dir.setPath(scorefile);
    if (!dir.exists()) dir.mkdir(scorefile);
    scorefile+="/krogue.scores";
  }
  if ((loaded=loadFile(scorefile))<=0) return;
}

int KScoreList::loadFile(const char *fn)
{
  int i, len;
  QFile f(fn);
  if (!user) turn_into_games();
  if (!QFile::exists(fn)) close(creat(fn, 0644));
  if (!f.open(IO_ReadOnly))
  {
    turn_into_user();
    return -1;
  }
  if (!user) turn_into_user();
  xxx(1);
  nScores=0;
  for (i=0; i<10; i++)
  {
    len=f.readBlock((char *)&scores[i], sizeof(scores[i]));
    if (!len) break;
    nScores++;
    if (len!=sizeof(scores[i])) return -2;
    xxxx((char *)&scores[i], sizeof(scores[i]));
  }
  return 0;
}

int KScoreList::writeFile(const char *fn)
{
  int i;
  QFile f(fn);
  if (!user) turn_into_games();
  if (!f.open(IO_ReadWrite))
  {
    if (!user) turn_into_user();
    return -1;
  }
  if (!user) turn_into_user();
  xxx(1);
  for (i=0; i<nScores; i++)
  {
    xxxx((char *)&scores[i], sizeof(scores[i]));
    f.writeBlock((char *)&scores[i], sizeof(scores[i]));
  }
  xxx(1);
  for (i=0; i<10; i++) xxxx((char *)&scores[i], sizeof(scores[i]));
  return 0;
}

int KScoreList::putScore(long gold, char *name, char *nick, short other, 
  short level, char m_char, char amulet)
{
  KScore s;
  int oldpos, newpos, i;
  s.gold=gold;
  s.other=other;
  s.level=level;
  s.m_char=m_char;
  s.amulet=amulet;
  strcpy(s.name, name);
  strcpy(s.nick, nick);
  oldpos=nScores;
  if (user) oldpos=nScores; else
    for (i=0; i<nScores; i++)
      if (strcmp(s.name, scores[i].name)==0)
      {
        oldpos=i;
        break;
      }
  if (oldpos==nScores && nScores<10) nScores++;
    else if (oldpos!=nScores && scores[oldpos].gold>s.gold) return 10;
  newpos=oldpos;
  for (i=oldpos; i>0; i--)
  {
    if (scores[i-1].gold>s.gold) break;
    if (i<nScores) scores[i]=scores[i-1];
    newpos=i-1;
  }
//  printf("nScores=%d, oldpos=%d, newpos=%d\n", nScores, oldpos, newpos);
  if (newpos<10) scores[newpos]=s;
  curr=newpos+1;
  if (writeFile(scorefile)<0)
    KMsgBox::message(kapp->mainWidget(), i18n("Rogue"), i18n("can't write to scores file!"));
  return newpos;
}

int KScoreList::current()
{
  return curr;
}

void KScoreList::setNick(const char *name, const char *nick)
{
  int i;
  for (i=0; i<nScores; i++)
    if (!strcmp(name, scores[i].name))
      qstrncpy(scores[i].nick, nick, 30);
  writeFile(scorefile);
}

QString &KScoreList::desc(int i)
{
  if (descs[i].isNull())
    if (i<nScores)
    {
      descs[i]=score_str(scores[i].nick[0]?scores[i].nick:scores[i].name,
        scores[i].m_char, scores[i].other, scores[i].level, scores[i].amulet,
	user);
    } else descs[i]="";
  return descs[i];
}

QString &KScoreList::score(int i)
{
  if (scorestr[i].isNull())
    if (i<nScores) scorestr[i].setNum(scores[i].gold);
      else scorestr[i]="";
  return scorestr[i];
}

KScoreDlg::KScoreDlg(bool _user, QWidget *parent)
:KHTMLDlg(QSize(670, 400), parent)
{
  char buf[160];
  user=_user;
  list=new KScoreList(_user);
  if (!list || list->loaded<0)
  {
    snprintf(buf, 160, i18n("Can't open score file %s"), 
      (const char *)list->scorefile);
    KMsgBox::message(parent, i18n("Rogue"), buf, KMsgBox::EXCLAMATION);
  } else load=1;
}

void KScoreDlg::listScores()
{
  char name[7], score[8];
  int i;
  if (!load) return;
  load=0;
  for (i=0; i<10; i++)
  {
    sprintf(name, "DESC%d", i+1);
    sprintf(score, "SCORE%d", i+1);
    setVar(name, list->desc(i));
    setVar(score, list->score(i));
  }
  if (list->current()!=0)
  {
    sprintf(currn, "%d", list->current());
    setVar("CURR", currn);
  }
  setVar("TOP_TEN_ROGUEISTS", user?i18n("Your top ten scores"):
    i18n("Top Ten Rogueists"));
  setVar("RANK", i18n("Rank"));
  setVar("SCORE", i18n("Score"));
  setVar("NAME", i18n("Name"));
  loadFile("top10.html");
}

int KScoreDlg::putScore(long gold, char *name, char *nick, short other, 
  short level, char m_char, char amulet)
{
  if (!load) return 10;
  return list->putScore(gold, name, nick, other, level, m_char, amulet);
}
