/***************************************************************************
                          questionswidget.cpp  -  description
                             -------------------
    begin                : Fri Jan 7 2000
    copyright            : (C) 2000 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "questionswidget.h"
#include <qpainter.h>
#include <iostream.h>

const int listbox_begin = 15;
// constructor
QuestionsWidget::QuestionsWidget(QWidget * parent, const char * name) : QWidget(parent,name)
{
    // defaults
    this -> resize (400,200);
    down_listbox = new QListBox(this);
    across_listbox = new QListBox(this);
    across_listbox -> setGeometry(0,0,200,200);
    down_listbox -> setGeometry(200,0,200,200);
}

void QuestionsWidget::resizeEvent(QResizeEvent * r)
{
    QSize s = r -> size();
    w = int( 0.5*s.width());
    h = s.height();
    across_listbox -> setGeometry(0,listbox_begin,w,h - listbox_begin);
    down_listbox -> setGeometry(w,listbox_begin,w,h - listbox_begin);
}

void QuestionsWidget::paintEvent( QPaintEvent *)
{
    QPainter p;
    p.begin(this);
    p.setPen(black);
    p.drawText(0,10,"Across");
    p.drawText(w,10,"Down");
    p.end();
}
