// POV-Ray 3.0 scenery

#include "colors.inc"

#declare size = .5     // half the width/height of the frame
#declare round = .05   // radius of the spherical rounding applied to edges
#declare border = BC * round

camera {
  orthographic
  location z*(-size/tan(27.5*pi/180)-round)
  right x 
  look_at 0
}

light_source {
  <-size/3, size/3, -3*size>
  White
}

#declare corner = intersection {
  sphere { 0, round }
  plane { x, 0 }
  plane { y, 0 }
  plane { z, 0 }
}

#declare edge = intersection {
  cylinder { (round-size)*x, (size-round)*x, round }
  plane { y, 0 }
  plane { z, 0 }
}

difference {
  union {
    box {
      <round-size, size-round, -round>
      <size-round, round-size, 0>
    }
    object { edge              translate (round-size)*y }
    object { edge rotate  90*z translate (size-round)*x }
    object { edge rotate 180*z translate (size-round)*y }
    object { edge rotate 270*z translate (round-size)*x }
    object { corner              translate <round-size, round-size, 0> }
    object { corner rotate  90*z translate <size-round, round-size, 0> }
    object { corner rotate 180*z translate <size-round, size-round, 0> }
    object { corner rotate 270*z translate <round-size, size-round, 0> }
  }
  box {
    <border-size, size-border, -size>
    <size-border, border-size, size>
  }
  pigment {
    image_map {
      gif "cedar.gif"
      interpolate 2
    }
    scale .3 / SC
    rotate 30*z
  }
  finish { ambient .3 }
  no_shadow
}

plane {
  -z, 0
  pigment { color White }
  finish {
    ambient 1.0
    diffuse 0.0
  }
  no_shadow
}
