Die Objekte Ref und RefPtr

Vorwort und Problem

Bislang war RefPtr ein simpler Pointer auf Ref. Damit knnen zwar sehr viele
Objekte ohne erhhten Speicheraufwand dargestellt werden, diese sind aber nur
uerlich zu transformieren. Fr Animationen von Massenszenen ist das Konzept
aber nahezu unbrauchbar, da hier innere Transformationen bentigt werden.
Schlielich bewegen sich alle Ameisen eines States nicht synchron, sondern
individuell in Rahmen von Parametern.

Lsung

Ref soll soetwas wie eine Modellschablone werden. Diese Schablone ist beliebig
vernderbar und jede nderung wirkt sich direkt auf zugehrige RefPtr aus.
Jedes Objekt RefPtr enthlt auer dem Pointer auf Ref zustzlich eine exakte
Kopie von Ref, welche aber nicht vernderbar ist. Alle Transformationen der
Kopie werden zu dem Original hinzu addiert. Dazu mssen die Transformationen
alle mit 1 initialisiert werden (mit 1 ist das neutrale Element der
Transformation gemeint). Wird nun ein Animationsscript von Ref auf RefPtr
angewand, so ndernt sich nur die Kopie von Ref, Ref selbst bleibt unberhrt.

Ergnzung

Man knnte eine berlegung anstellen, da die Kopie zwar in ihrer Struktur
nicht nderbar sein darf, wohl aber ihre Transformationen. Dabei kommen wir
dann zum Namenproblem. Jedes Objekt ist eindeutig ber seinen Namen
bestimmbar. Das bedeutet, da alle Kopien umbenant werden mten. Doch dann
sind diese ber die Animscripte von Ref nicht mehr animierbar. Daraus folgen
zwei Schlsse:

	1. drfen die Kopien nicht umbenannt werden
	2. da die Namen der Kopien nicht eindeutig sind, darf nur das System
	   selbst nderungen vornehmen
	3. die Dateistrukturen mssen nicht gendert werden
	4. mglicher Weise mssen aber einige Animroutinen berschrieben werden

Vorgehen

Zunchst sollten zwei neue Objekte erzeugt werden, Template aus Ref und Form
aus RefPtr. Dann sollte die weitere Implementierung davon ausgehen.

