/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** csgobj.cpp
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "csgobj.h"

csgobj::csgobj(base *p,const char *n,texture *t) :
	atom(p,n,t)
{
	numtype = NUM_CSGOBJ;
}

csgobj::csgobj(base *p,const char *n,Vector3 &vs,Vector3 &vr,Vector3 &vt) :
	atom(p,n,vs,vr,vt)
{
	numtype = NUM_CSGOBJ;
}

csgobj::csgobj(base *p,const char *n,texture *t,Vector3 &vs,Vector3 &vr,Vector3 &vt) :
	atom(p,n,t,vs,vr,vt)
{
	numtype = NUM_CSGOBJ;
}

csgobj::csgobj(base *p,csgobj *cc) :
	atom(p,cc)
{
	numtype = NUM_CSGOBJ;
}

csgobj::~csgobj()
{
	removeFromParent();
}

void	csgobj::dumpNames(int tab,int)
{
	printTab(stdout,tab);
	printf("csgobj: %s\n",name);
}

int	csgobj::addToParent(base *p)
{
	if(!p) return -2;

	parent = p;
	return p->addChild(this);
}

int	csgobj::removeFromParent() 
{ 
	if(!parent) return -2; 
	return parent->removeChild(this); 
} 


