/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** cmesh.h
*/

#ifndef __CMESH_H__
#define __CMESH_H__

#include <list.h>
#include <classes.h> 
#include <matmath.h> 

#include <objects.h> 

#include "mesh.h" 

class graph; 
class edge; 


class cmesh : public csgobj
{
private:
	struct dvec {Vector3 position,direction;};
	struct seg {int	pointnum[3];};

protected:
	simplelist<dvec>	vectorlist;
	simplelist<seg>		trianglelist;

	graph			*gptr;

public:
	cmesh(base *p=0,char *n="Untitled",texture *t=0);
	cmesh(base *p,char *n,Vector3&,Vector3&,Vector3&);
	cmesh(base *p,char *n,texture *t,Vector3&,Vector3&,Vector3&);
	cmesh(base *p,cmesh *mc);

	cmesh(mesh&);	// Typumwandlung

	~cmesh();

	virtual int	addChild(csgobj*);
	virtual int	addChild(blobobj*);

	int		addChild(box*);
	int		addChild(cone*);
	int		addChild(cylinder*);
	int		addChild(sphere*);
	int		addChild(text*);

	int		addKnode(double x, double y, double z,double nx = 0, double ny = 0, double nz = 0);
	int		addKnode(Vector3 v,Vector3 n = Vector3(0,0,0));
	int		addSegment(int p1,int p2,int p3);

	int		getKnode(int,Vector3&,Vector3&);
	Vector3		&getPoint(int);
	Vector3		&getNormal(int);
	int		getSegment(int,int&,int&,int&);

	int		removeSegment(int segnum);
	int		removeKnode(int knodenum);

	int		isClose();
	list<edge*>	getOpenPolygone(list<edge*>);
	int		closeMesh();
	int		close();

	int		isConvex();

	int		simplify(double);
	int		subdivide();
	int		subdivideClever(int base,double grade);

	int		addMesh(cmesh&);
	int		addMesh(cmesh*);

	int		subtractMesh(cmesh&);
	int		subtractMesh(cmesh*);

	int		intersectMesh(cmesh&);
	int		intersectMesh(cmesh*);

	virtual int	addToParent(base *);
	virtual int	removeFromParent();

	virtual base	*copy(base*);

	virtual void	dumpNames(int,int);

	virtual int	exportPOV(FILE *,int,int,int anim = 0);
	virtual int	save(media*);
	virtual int	load(media*,int);

	virtual int	draw(view *,Matrix44,int);
	virtual int	calculate(int);
	virtual double	volume(int) 
	{ 
		return 0; 
	} 

private:
	int		exportPOVMesh(FILE*,int,int,int);
	int		exportPOVCSG(FILE*,int,int,int);

	graph		*createGraph();
	int		createFromGraph(graph*);

	int		addSegment(edge *p1,edge *p2,edge *p3);
};


#endif



