/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** plane.cpp
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "plane.h"
#include "num.h"

#include "view.h"

plane::plane(base *p,char *n,texture *t) :
	csgobj(p,n,t)
{
	numtype = NUM_PLANE;

	if(parent) addToParent(parent);
}

plane::plane(base *p,char *n,Vector3 &vs,Vector3 &vr,Vector3 &vt) :
	csgobj(p,n,vs,vr,vt)
{
	numtype = NUM_PLANE;

	if(parent) addToParent(parent);
}

plane::plane(base *p,char *n,texture *t,Vector3 &vs,Vector3 &vr,Vector3 &vt) :
	csgobj(p,n,t,vs,vr,vt)
{
	numtype = NUM_PLANE;

	if(parent) addToParent(parent);
}

plane::plane(base *p,plane *pc) :
	csgobj(p,(csgobj*)pc)
{
	numtype = NUM_PLANE;

	if(parent) addToParent(parent);
}

plane::~plane()
{
	removeFromParent();
}

base	*plane::copy(base *p)
{
	return new plane(p,this);
}

void	plane::dumpNames(int tab,int)
{
	printTab(stdout,tab);
	printf("plane: %s\n",name);
}

int 	plane::addToParent(base *p)
{
	if (!p) return -2;

	parent = p;
	return p->addChild(this);
}

int 	plane::removeFromParent()
{
	if (!parent) return -2;
	return parent->removeChild(this);
}
 
int	plane::exportPOV(FILE *fp,int tab,int tabsize,int anim) 
{ 
	if(isFlag(NO_EXPORT)) return 0;

	printTab(fp,tab); 
	fprintf(fp,"// Objectname = %s\n",name); 
	printTab(fp,tab);
	fprintf(fp,"// Objecttype = plane\n");
	printTab(fp,tab);
	fprintf(fp,"plane\n");
	printTab(fp,tab); 
	fprintf(fp,"{\n"); 
	printTab(fp,tab + tabsize); 
	fprintf(fp,"< 0, 1, 0>, 0\n"); 
	
	if(texptr)
		texptr->exportPOV(fp,tab + tabsize,tabsize,anim);

	dim::exportPOV(fp,tab + tabsize,tabsize,anim);

	if(isFlag(HOLLOW_ON))
	{
		printTab(fp,tab + tabsize);
		fprintf(fp,"hollow on\n");
	}
	else if(isFlag(HOLLOW_OFF))
	{
		printTab(fp,tab + tabsize);
		fprintf(fp,"hollow off\n");
	}
	
	printTab(fp,tab);
	fprintf(fp,"}\n");

	return 0;
}

int	plane::save(media *m)
{
	setMedia(m);

	writeChunk("PLNE");
	writeNameChunk(name);

	saveFlags(m);

	anim::save(m);
	dim::save(m);
	saveTexture(m);

	writeChunkLen();

	return 0;
}

int	plane::load(media *m,int l)
{
	int	pos = m->tell();

	loadFlags(m,l);

	anim::load(m,l - (m->tell() - pos));
	dim::load(m,l - (m->tell() - pos));

	if(l > (m->tell() - pos))
	{
		loadTexture(m,l - (m->tell() - pos));
	}

	return 0;
}

int	plane::draw(view *v,Matrix44 m,int anim)
{
	Vector3	p,vx,vy,vz;

	//printf("Plane\n");

	if(isFlag(HIDE)) return 0;

	p = Vector3(0,0,0);
	vx = Vector3(1,0,0);
	vy = Vector3(0,1,0);
	vz = Vector3(0,0,1);

	dimMatrix(m,anim);

	if(this == v->getSelected()) v->setDrawSelected(1);

	v->drawLine(vx + vz * 1.1,vx - vz * 1.1,m,anim);
	v->drawLine(vx * 1.1 - vz,-vx * 1.1 - vz,m,anim);
	v->drawLine(-vx - vz * 1.1,-vx + vz * 1.1,m,anim);
	v->drawLine(-vx * 1.1 + vz,vx * 1.1 + vz,m,anim);
//	v->drawLine(p,vy * 1,m);

	if(this == v->getSelected()) v->setDrawSelected(0);

	if(isFlag(DRAW_AXIS))
		v->drawAxis(m,anim);

	drawDragvectors(v,m,anim);

	return 0;
}

int	plane::calculate(int)
{
	vmin = vmax = Vector3(0,0,0);

	return 0;
}

int	plane::isFinite()
{
	return 0;
}

double	plane::volume(int anim)
{
	return 1e1000;
}



