/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** colorlist.cpp
*/
#include "colorlist.h"

#include <misc.h>


static char	fnname[colorList::NFunctions][20] =
		{
		"brick",
		"checker",
		"hexagon"
		};


colorList::colorList(textureBase *p):textureBase(COLORLIST,p)
{

	fn=Checker;

	setName("Colorlist");
	setInfo("Colorlist");
	setSubItems(true);
	elementnr=0;
}

void	colorList::setActive(bool a,textureBase *tb)
{
	if (tb==NULL) {textureBase::setActive(a);return;}
	if (tb->getType()==COLORLIST) textureBase::setActive(a);
	else tb->setActive(a);
}



textureBase *colorList::getFirstElement()
{
#ifdef DEBUG
	printf("Getting first Colorlist-Element\n");
#endif
	elementnr=0;
	if (elements.length()==0) return NULL;
	return elements[0];
	
}

textureBase *colorList::getNextElement()
{
	elementnr++;
	if (elementnr>=elements.length()) return NULL;

#ifdef DEBUG
	printf("Getting next ColorList-Element (%d,%d)\n",elementnr,elements.length() );
#endif
	return elements[elementnr];

}

void colorList::addElement(textureBase* what,textureBase* where)
{
int t=-1,i;
        if(!what) return;
	what->setParent(this);
	what->setActive(true);

	if (what->getType()==TRANSFORMATIONS) {
		for (i=0;i<elements.length();i++){
			if (elements[i]->getType()==TRANSFORMATIONS) {
				elements.deleteAt(i);
				elements.append(what);
				return;
			}
		}			
		elements.append(what);
		return;
	}
	if (what->getType()==TURBULENCEMODIFIER) {
		for (i=0;i<elements.length();i++){
			if (elements[i]->getType()==TURBULENCEMODIFIER) {
				elements.deleteAt(i);
				elements.append(what);
				return;
			}
		}			
		elements.append(what);
		return;
	}
	if (what->getType()==COLORMAP) {
		textureBase *tb=what->getFirstElement();
		while (tb!=NULL) {
			color *c=new color(this);
			c->add(tb);
			elements.append(c);
			tb=what->getNextElement();
		}
		return;
	}
	if (what->getType()==COLORENTRY) {
		color *c=new color(this);
		c->add(what);
		elements.append(c);
		return;
	}


	if (where) t=elements.find(where);
	if ((where==NULL)||(t==-1)) {
#ifdef DEBUG
	printf("Adding Colorlist-Element (l=%d)\n",elements.length());
#endif
		elements.append(what);
		return;
	}
	elements.insertAt(what,t);
	updateInfo();
}



bool colorList::isEqual(textureBase *tb)
{
int  i;
colorList *cl=(colorList *)tb;
textureBase *tb1;
#ifdef DEBUG
	printf("Comparing Colorlist...\n");
#endif

	if (tb->getType()!=COLORLIST) return false;
	if (cl->getColorListFunction()!=fn) return false;
	tb1=tb->getFirstElement();
	if ((tb1==NULL)&&(elements.length()==0)) return true;
	for (i=0;i<elements.length();i++) {
		if (tb1==NULL) return false;
		if ( tb1->isEqual(elements[i])==false) return false;
		tb1=tb->getNextElement();
	}
#ifdef DEBUG
	printf("Comparing Colorlist...found !\n");
#endif
	return true;
}

void colorList::remove(textureBase *tb)
{
int i;
	for (i=0;i<elements.length();i++) {
		if (tb->isEqual(elements[i])) {
			elements.deleteAt(i);			
			i=elements.length()+1;
		}
	}
	updateInfo();
}



colorList::~colorList()
{
}

void colorList::updateInfo()
{
char *buffer=(char *)malloc(512);
	sprintf(buffer,"Pattern:%s",getColorListFunctionName());
	setInfo(buffer);
	free(buffer);
}

void colorList::setColorListFunction(FUNCTION f)
{
	fn=f;
	updateInfo();
}

int colorList::getColorListFunction()
{
	return fn;
}

char *colorList::getColorListFunctionName()
{
	return fnname[fn];
}

char *colorList::getColorListFunctionNameList(int n)
{
	return fnname[n];
}

int	colorList::load(media *m,int l)
{
	char	chunk[4];
	bool 	read;
	int	len,pos = m->tell();

	if(!m)	return -1;
	
	#ifdef DEBUG
		printf("loading ColorList\n");
	#endif

	setMedia(m);

	do {
		m->read(chunk,4);
		m->read(&len,4);
		read=false;
		if(strncmp(chunk,"COLR",4) == 0) {
			color *col=new color(this);
			col->load(m,len);
			addElement(col,NULL);
			read=true;
		}
		if(strncmp(chunk,"CLFN",4) == 0) {
			m->read(&fn,4);
			read=true;
		}
		if(strncmp(chunk,"BASE",4) == 0) {
			textureBase::load(m,len);
			read=true;
		}

		if (read==false) { m->seek(len,SEEK_CUR); }

	} while (m->tell()< (pos+l) );


	m->seek(pos+l,SEEK_SET);

	#ifdef DEBUG
		printf("ColorList loaded\n");
	#endif

	updateInfo();
	return 0;
}

bool	colorList::canAdd(textureBase *tb)
{
int t=tb->getType();
	if (t==COLOR) return true;
	if (t==COLORENTRY) return true;
	if (t==COLORMAP) return true;
	if (t==COLORLIST) return false;
	//if (t==TURBULENCEMODIFIER) return true;
	//if (t==TRANSFORMATIONS) return true;
	return false;
}

void	colorList::add(textureBase *tb)
{
	if (tb==NULL) return;
	if (canAdd(tb)==false) return;
	addElement(tb,NULL);

	updateInfo();
}


int	colorList::save(media *m)
{
int i;
chunk ch;
	if(!m) return -1;
	#ifdef DEBUG
		printf("saving ColorList\n");
	#endif
	setMedia(m);

	writeChunk("COLL");

	textureBase::save(m);
        ch.setMedia(m);
	ch.writeChunk("CLFN");
		m->write(&fn,4);
	ch.writeChunkLen();

	for (i=0;i<elements.length();i++) {
		elements[i]->save(m);
	}

	writeChunkLen();

	#ifdef DEBUG
		printf("ColorList saved\n");
	#endif
	return 0;
}

int colorList::exportPOV(FILE *fp,int tab,int tabsize,int a, bool dummy)
{
int i;
color *c;
	if(fp == 0)
		return -1;
	#ifdef DEBUG
		printf("exporting ColorList (POV)\n");
	#endif
	
	printTab(fp,tab);
	fprintf(fp,"%s  //%s\n ",getColorListFunctionName(),getName() );

	for (i=0;i<elements.length();i++) {
		if ((elements[i]->active()==true)&&(elements[i]->getType()==COLOR)) {
                		c=(color *)elements[i];
				printTab(fp,tab);
				fprintf(fp,"color rgbt <%g, %g, %g, %g>,\n",c->red(),c->green(),c->blue(),c->transparency() );
		}
	}
/*	for (i=0;i<elements.length();i++)  {
		if ((elements[i]->active()==true)&&(elements[i]->getType()==TURBULENCEMODIFIER)) elements[i]->exportPOV(fp,tab,tabsize,a,false);
	}
	for (i=0;i<elements.length();i++)  {
		if ((elements[i]->active()==true)&&(elements[i]->getType()==TRANSFORMATIONS)) elements[i]->exportPOV(fp,tab,tabsize,a,false);
	}
*/	
	#ifdef DEBUG
		printf("ColorList exported (POV)\n");
	#endif

	return 0;
}
