/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** pigment.cpp
*/
#include "pigment.h"

/* XPM */
const char*pigmentfolder[]={
"15 13 10 1",
"h c #a0a0a0",
"f c #00ff00",
"d c #000000",
"b c #ffff00",
"g c #0000ff",
"# c #999999",
". c None",
"a c #cccccc",
"c c #ffffff",
"e c #ff0000",
"..#####........",
".#ababa#.......",
"#abababa######.",
"#cccccccccccc#d",
"#cbeeebabfffb#d",
"#ceeeeebfffff#d",
"#ceeeeecfffff#d",
"#ceeeecccffff#d",
"#cbeecccccffb#d",
"#cabaggcggaba#d",
"#cbabgggggbab#d",
"#hhhhhhhhhhhh#d",
".dddddddddddddd"};

pigment::pigment(textureBase *p) :textureBase(PIGMENT,p)
{

	setName("Pigment");
        setInfo("Pigment");
	setSubItems(true);	

  	quickcolor=new color(NULL);

	elementnr=0;

}

const char **pigment::getXPM()
{
	return pigmentfolder;
}

void	pigment::setActive(bool a,textureBase *tb)
{
int i;

	if (tb==NULL) {
		textureBase::setActive(a,NULL);
		return;
	}

	if ((tb->getType()==TURBULENCEMODIFIER)||
	     (tb->getType()==TRANSFORMATIONS)) {
			tb->setActive(a);
			return;
	}

	if (a==false) return;
	for (i=0;i<elements.length();i++) elements[i]->setActive(false);
	tb->setActive(true);
}


textureBase *pigment::getFirstElement()
{
#ifdef DEBUG
	printf("Getting first Pigment-Element (length=%d)\n",elements.length());
#endif
	elementnr=0;
	if (elements.length()==0) return NULL;
	return elements[0];
	
}

textureBase *pigment::getNextElement()
{
	elementnr++;
	if (elementnr>=elements.length()) return NULL;

#ifdef DEBUG
	printf("Getting next Pigment-Element (%d,%d)\n",elementnr,elements.length() );
#endif
	return elements[elementnr];

}


void pigment::addElement(textureBase* what,textureBase* where)
{
int t=-1;
int i;

	if (what==NULL) return;
	what->setParent(this);
	setActive(true,what);
	if (what->getType()==TRANSFORMATIONS) {
		for (i=0;i<elements.length();i++){
			if (elements[i]->getType()==TRANSFORMATIONS) {
				elements.deleteAt(i);
				elements.append(what);
				return;
			}
		}			
		elements.append(what);
		return;
	}
	if (what->getType()==TURBULENCEMODIFIER) {
		for (i=0;i<elements.length();i++){
			if (elements[i]->getType()==TURBULENCEMODIFIER) {
				elements.deleteAt(i);
				elements.append(what);
				return;
			}
		}			
		elements.append(what);
		return;
	}
	if (what->getType()==COLORENTRY) {
		color *c=new color(this);
		c->add(what);
		elements.append(c);
		return;
	}
	if (where) t=elements.find(where);
	if ((where==NULL)||(t==-1)) {
#ifdef DEBUG
	printf("Adding Pigment-Element (l=%d)\n",elements.length());
#endif
		elements.append(what);
		return;
	}
	elements.insertAt(what,t);

		
}

void pigment::setQuickColor(color *c)
{
	if (quickcolor) delete quickcolor;
	quickcolor=c;
}

color *pigment::getQuickColor(textureBase *tb)
{

	return quickcolor;
}

void pigment::remove(textureBase *tb)
{
int i;
	for (i=0;i<elements.length();i++) {
		if (tb->isEqual(elements[i])) {
			elements.deleteAt(i);			
			i=elements.length()+1;
		}
	}
}

pigment::~pigment()
{
}

bool pigment::canAdd(textureBase *tb)
{
	if (!tb) return false;
	if (tb->getType()==COLOR) return true;
	if (tb->getType()==COLORENTRY) return true;
	if (tb->getType()==COLORLIST) return true;
	if (tb->getType()==COLORMAP) return true;
	if (tb->getType()==PIGMENT) return true;
	if (tb->getType()==PIGMENTLIST) return false;
	if (tb->getType()==PIGMENTMAP) return false;
	if (tb->getType()==IMAGEMAP) return true;
	if (tb->getType()==TRANSFORMATIONS) return true;
	if (tb->getType()==TURBULENCEMODIFIER) return true;
	return false;
}


void pigment::add(textureBase *tb)
{
	if (!tb) return
	tb->setParent(this);	
	addElement( tb,NULL);
}

bool pigment::isEqual(textureBase *tb)
{
textureBase *tb1;
int i;
#ifdef DEBUG
	printf("Comparing Pigments..\n");
#endif

	if (tb->getType()!=PIGMENT) return false;
	if (textureBase::isEqual(tb)==false) return false;
	tb1=tb->getFirstElement();
	if ( ( (tb1==NULL)&&(elements.length()==0) ) ) return true;
	for (i=0;i<elements.length();i++) {
     		if (tb1==NULL) return false;
		if (tb1->isEqual(elements[i])==false) return false;
		tb1=tb->getNextElement();		
	}

#ifdef DEBUG
	printf("Compared Pigments..found it !\n");
#endif
	return true;

}


int	pigment::load(media *m,int l)
{
	char	chunk[4];
	bool 	read;
	int	len,pos = m->tell();
	double a;




	if(!m) return -1;
	setMedia(m);
#ifdef DEBUG
	printf("loading pigment\n");
#endif

	do {
		m->read(chunk,4);
		m->read(&len,4);
		read=false;
		if(strncmp(chunk,"QUIC",4) == 0) {
			m->read(&a,sizeof(double));
			quickcolor->setRed(a);
			m->read(&a,sizeof(double));
			quickcolor->setGreen(a);
			m->read(&a,sizeof(double));
			quickcolor->setBlue(a);
			read=true;	
		}

		if(strncmp(chunk,"COLR",4) == 0) {
			color *col=new color(this);
			col->load(m,len);
			addElement(col,NULL);
			read=true;
		}
		if(strncmp(chunk,"COLL",4) == 0) {
			colorList *colList=new colorList(this);
			colList->load(m,len);
			addElement(colList,NULL);
			read=true;
		}
		if(strncmp(chunk,"TRNS",4) == 0) {
			Transformations *trans=new Transformations(this);
			trans->load(m,len);
			addElement(trans,NULL);
			read=true;
		}
		if(strncmp(chunk,"TURB",4) == 0) {
			Turbulence *turb=new Turbulence(this);
			turb->load(m,len);
			addElement(turb,NULL);
			read=true;
		}
		if(strncmp(chunk,"COLM",4) == 0) {
			colorMap *colMap=new colorMap(this);
			colMap->load(m,len);
			addElement(colMap,NULL);
			read=true;

		}
		if(strncmp(chunk,"IMGM",4) == 0) {
			imageMap *imgMap=new imageMap(this);
			imgMap->load(m,len);
			addElement(imgMap,NULL);
			read=true;
		}
		if(strncmp(chunk,"PIGM",4) == 0) {
			//pigmentMap *pigMap=new pigmentMap(this);
			//pigMap->load(fp,len-4);
			//addElement(pigMap,NULL);			
			read=true;
		}
		if(strncmp(chunk,"PIGL",4) == 0) {
			//pigmentList *pigList=new pigmentList(this);
			//pigList->load(fp,len-4);
			//addElement(pigList,NULL);
			read=true;
		}
		if(strncmp(chunk,"BASE",4) == 0) {
			textureBase::load(m,len);
			read=true;
		}
		if (read==false) { m->seek(len,SEEK_CUR); }

	} while (m->tell()< (pos+l) );

	m->seek(pos+l,SEEK_SET); // Man weiss ja nie...  c
#ifdef DEBUG
	printf("loaded pigment\n");
#endif
	return 0;
}

int	pigment::save(media *m)
{
double a;
int i;
chunk c;

	if(!m) return -1;

	setMedia(m);
#ifdef DEBUG
	printf("saving pigment\n");
#endif
	writeChunk("PGMT");

	textureBase::save(m);

	c.setMedia(m);
	c.writeChunk("QUIC");
		a=quickcolor->red();
		m->write(&a,sizeof(double));
		a=quickcolor->green();
		m->write(&a,sizeof(double));
		a=quickcolor->blue();
		m->write(&a,sizeof(double));
	c.writeChunkLen();


	for (i=0;i<elements.length();i++) {
		elements[i]->save(m);
	}


	writeChunkLen();

#ifdef DEBUG
	printf("pigment saved\n");
#endif
	return 0;
}

int	pigment::exportPOV(FILE *fp,int tab,int tabsize,int a, bool as_map)
{
int i;

	#ifdef DEBUG
		printf("Exporting Pigment (POV)\n");
	#endif

	if(fp == 0)
		return -1;

	printTab(fp,tab);
	fprintf(fp,"pigment  //Name:%s\n",name);

	printTab(fp,tab);
	fprintf(fp,"{\n");

	for (i=0;i<elements.length();i++) {
		if (elements[i]->active()==true) {
		elements[i]->exportPOV(fp,tab+tabsize,tabsize,a,as_map);
		}
	}

	printTab(fp,tab+tabsize);
	fprintf(fp,"quick_color rgb<%g,%g,%g>\n",quickcolor->red(),quickcolor->green(),quickcolor->blue());	

	printTab(fp,tab);
        fprintf(fp,"}\n");

	#ifdef DEBUG
		printf("Exported Pigment (POV)\n");
	#endif

	return 0;
}

