/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** pigmententry.cpp
*/
#include "pigmententry.h"
#include <chunk.h>

pigmentEntry::pigmentEntry(double val, pigment *pig):chunk()
{
	range=val;
	p=pig;
		
}

pigmentEntry::~pigmentEntry()
{
}

void	pigmentEntry::setPigmentRange(double n)
{
	range=n;
}

double	pigmentEntry::getPigmentRange()
{
	return range;
}

int	pigmentEntry::save(media *m)
{	/*
	if(!fp) return -1;
	#ifdef DEBUG
		printf("saving pigmentEntry\n");
	#endif
	setFile(fp);
	
	writeChunk("PGME");

	SD(range);
	p->save(fp);

	writeChunkLen();
	#ifdef DEBUG
		printf("PigmentEntry saved\n");
	#endif*/
	return 0;
}

int	pigmentEntry::load(media *m,int l)
{/*
	int i;
	char	chunk[4];
	int	len,pos = ftell(fp);

	if(!fp)
		return -1;
	i=0;
	#ifdef DEBUG
		printf("loading pigmentEntry\n");
	#endif
	fread(&range,1,sizeof(double),fp);
	fread(chunk,1,4,fp);
	fread(&len,1,4,fp);
	if(strncmp(chunk,"PGME",4) == 0) {
		p=new pigment(0);
		p->load(fp,len);
	}

	fseek(fp,pos+l,SEEK_SET); // Man weiss ja nie...
	#ifdef DEBUG
		printf("PigmentEntry loaded\n");
	#endif*/
	return 0;
}

int		pigmentEntry::exportPOV(FILE *fp,int tab,int tabsize, int a)
{
	if(!fp) return -1;
	#ifdef DEBUG
		printf("exporting pigmentEntry (POV)\n");
	#endif
	printTab(fp,tab);
	fprintf(fp,"[ %g ",range);

	p->exportPOV(fp,tab+tabsize,tabsize,a,true);

	printTab(fp,tab);
	fprintf(fp,"]\n");
	#ifdef DEBUG
		printf("PigmentEntry exported (POV)\n");
	#endif
	return 0;
}

