/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** slopemap.cpp
*/
#include "slopemap.h"

#include <misc.h>

slopeMap::slopeMap(textureBase *p):textureBase(SLOPEMAP,p)
{
	setName("Slopemap");
	setInfo("Slopemap");
	setSubItems(true);
	elementnr=0;
}

patternmodifier	*slopeMap::getMapModifier()
{
	return &modifier;
}

textureBase *slopeMap::getFirstElement()
{
#ifdef DEBUG
	printf("Getting first Slopemap-Element (length=%d)\n",elements.length());
#endif
	elementnr=0;
	if (elements.length()==0) return NULL;
	return elements[0];
	
}

textureBase *slopeMap::getNextElement()
{
#ifdef DEBUG
	printf("Getting next Slopemap-Element (length=%d)\n",elements.length());
#endif
	elementnr++;
	if (elementnr>=elements.length()) return NULL;

	return elements[elementnr];

}

bool slopeMap::isEqual(textureBase *tb)
{
textureBase *tb1;
int i;
#ifdef DEBUG
	printf("Comparing Slopemaps..\n");
#endif

	if (tb==NULL) return false;
	if (tb->getType()!=SLOPEMAP) return false;
	if (textureBase::isEqual(tb)==false) return false;
	tb1=tb->getFirstElement();
	if ( ( (tb1==NULL)&&(elements.length()==0) ) ) return true;
	for (i=0;i<elements.length();i++) {
     		if (tb1==NULL) return false;
		if (tb1->isEqual(elements[i])==false) return false;
		tb1=tb->getNextElement();		
	}

#ifdef DEBUG
	printf("Compared Slopemaps..found it !\n");
#endif
	return true;
}


slopeMap::~slopeMap()
{
}

void slopeMap::add(textureBase *tb)
{
	if (!tb) return;
	addElement(tb,NULL);
}

void slopeMap::setActive(bool a, textureBase *tb)
{
	if (tb==NULL) {
		textureBase::setActive(a,NULL);
		return;
	}
	tb->setActive(a,NULL);
}

void slopeMap::addElement(textureBase* what,textureBase *where)
{
int t,i;


#ifdef DEBUG
	printf("Adding Slopemap-Element (length=%d)\n",elements.length());
#endif

      	if (what==NULL) return;
	if (canAdd(what)==false) return;
	what->setParent(this);
	what->setActive(true,NULL);
	t=what->getType();
	switch (t) {
		case SLOPEENTRY:
			elements.append(what);
		break;
		case TRANSFORMATIONS:
			for (i=0;i<elements.length();i++){
				if (elements[i]->getType()==TRANSFORMATIONS) {
					elements.deleteAt(i);
					elements.append(what);
					return;
				}
			}			
			elements.append(what);
			return;
		break;
		case TURBULENCEMODIFIER:
			for (i=0;i<elements.length();i++){
				if (elements[i]->getType()==TURBULENCEMODIFIER) {
					elements.deleteAt(i);
					elements.append(what);
					return;
				}
			}			
			elements.append(what);
			return;
		break;
		case SLOPEMAP:
		{
		textureBase *tb=what->getFirstElement();
			while(tb!=NULL) {
				slopeEntry *se=new slopeEntry(this);
				se->add( (slopeEntry *)tb);
				elements.append(se);
				tb=what->getNextElement();					
			}
		}
		break;
		default:
		break;
	
	}
	sortSlopeMap();
	updateInfo();
}


bool slopeMap::canAdd(textureBase *tb)
{
	if (tb->getType()==SLOPEENTRY) return true;
	if (tb->getType()==SLOPEMAP) return false;
	if (tb->getType()==TURBULENCEMODIFIER) return true;
	if (tb->getType()==TRANSFORMATIONS) return true;
	if (tb->getType()==PATTERNMODIFIER) return true;

	return false;
}

void slopeMap::remove(textureBase *tb)
{
int i;
	for (i=0;i<elements.length();i++) {
		if (tb->isEqual(elements[i])) {
			elements.deleteAt(i);			
			i=elements.length()+1;
		}
	}
	sortSlopeMap();
	updateInfo();
}

void slopeMap::updateInfo()
{
	char *buffer=(char *)malloc(512);
	
	sprintf(buffer,"Slopemap (%d Elements)",elements.length());
	setInfo(buffer);
	free(buffer);
}

void slopeMap::sortSlopeMap()
{
int a,i,j;
slopeEntry *se;
	#ifdef DEBUG
		printf("sorting SlopeMap\n");
	#endif
	a=elements.length();

	for (i=1;i<a;i++) {
		for (j=0;j<i;j++) {
			if ( ((slopeEntry*)elements[j])->getSlopeNum()>((slopeEntry*)elements[j+1])->getSlopeNum() ) {
				//printf("swapped\n");
				se=(slopeEntry*)elements[j+1];
				elements[j+1]=elements[j];
				elements[j]=se;

			}
		}
	}	
	#ifdef DEBUG
		printf("SlopeMap sorted\n");
	#endif
}


int	slopeMap::load(media *m,int l)
{
	char	chunk[4];
	bool 	read;
	int	len,pos = m->tell();

	if(!m) return -1;
	setMedia(m);

	#ifdef DEBUG
		printf("loading SlopeMap\n");
	#endif

	do {
		m->read(chunk,4);
		m->read(&len,4);
		read=false;

		if(strncmp(chunk,"SLPE",4) == 0) {
			slopeEntry *se=new slopeEntry(this);
			se->load(m,l);
			elements.append(se);
			read=true;
		}
		if(strncmp(chunk,"PATM",4) == 0) {
			modifier.load(m,len);
			read=true;
		}
		if(strncmp(chunk,"TRNS",4) == 0) {
			Transformations *trans=new Transformations(this);
			trans->load(m,len);
			addElement(trans,NULL);
			read=true;
		}
		if(strncmp(chunk,"TURB",4) == 0) {
			Turbulence *turb=new Turbulence(this);
			turb->load(m,len);
			addElement(turb,NULL);
			read=true;
		}
		if(strncmp(chunk,"BASE",4) == 0) {
			textureBase::load(m,len);
			read=true;
		}	
		if (read==false) { m->seek(len,SEEK_CUR); }
	} while (m->tell()< (pos+l) );

	m->seek(pos+l,SEEK_SET); // Man weiss ja nie...

	#ifdef DEBUG
		printf("SlopeMap loaded\n");
	#endif
	return 0;
}

int	slopeMap::save(media *m)
{
int i;
	if(!m) return -1;

	#ifdef DEBUG
		printf("saving SlopeMap\n");
	#endif

	setMedia(m);
		
	writeChunk("SLPM");
	textureBase::save(m);

	for (i=0;i<elements.length();i++)  {
		elements[i]->save(m);			
	}
	modifier.save(m);

	writeChunkLen();

	#ifdef DEBUG
		printf("SlopeMap saved\n");
	#endif

	return 0;
}

int slopeMap::exportPOV(FILE *fp,int tab,int tabsize,int anim,bool dummy)
{
int i;
	if(fp == 0) return -1;
	#ifdef DEBUG
		printf("exporting SlopeMap (POV)\n");
	#endif

	modifier.exportPOV(fp,tab,tabsize,anim,false);
	printTab(fp,tab);
	fprintf(fp,"slope_map { //%s\n",getName() );	
	for (i=0;i<elements.length();i++)  {
		if ((elements[i]->active()==true)&&(elements[i]->getType()==SLOPEENTRY)) elements[i]->exportPOV(fp,tab+tabsize,tabsize,anim,false);			
	}
	printTab(fp,tab);
	fprintf(fp,"}\n" );	

	for (i=0;i<elements.length();i++)  {
		if ((elements[i]->active()==true)&&(elements[i]->getType()==TURBULENCEMODIFIER)) elements[i]->exportPOV(fp,tab,tabsize,anim,false);	
	}
	for (i=0;i<elements.length();i++)  {
		if ((elements[i]->active()==true)&&(elements[i]->getType()==TRANSFORMATIONS)) elements[i]->exportPOV(fp,tab,tabsize,anim,false);
	}

	#ifdef DEBUG
		printf("SlopeMap exported (POV)\n");
	#endif
	return 0;
}

