/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** texturebase.cpp
*/
#include "texturebase.h"
#include <chunk.h>

const char *TBunknownPic[] = {
"5 9 2 1",
" 	c None",
".	c #000000",
"     ",
".. . ",
"   ..",
"   . ",
"  .  ",
" .   ",
"     ",
"..   ",
".    "};

const char *TBYellowFolderPic[]={
"15 13 6 1",
"d c #000000",
"b c #ffff00",
". c None",
"# c #999999",
"a c #cccccc",
"c c #ffffff",
"..#####........",
".#ababa#.......",
"#abababa######.",
"#cccccccccccc#d",
"#cbababababab#d",
"#cabababababa#d",
"#cbababababab#d",
"#cabababababa#d",
"#cbababababab#d",
"#cabababababa#d",
"#cbababababab#d",
"##############d",
".dddddddddddddd"};

textureBase::textureBase(ttyp t,textureBase *tb):chunk()
{
	name=NULL;
	name=strdup("Unnamed");
	author=strdup("unknown");
	description=strdup("");
	flags=0;
	ptr=strdup("");
	parent=tb;
	typ=t;
	locks=0;

	subitems=false;
	Active=false;

	info=NULL;
	open=true;
	selected=false;

	setInfo("No info avaiable");
}

void textureBase::setSelected(bool a)
{
	selected=a;
}

bool textureBase::isSelected()
{
	return selected;
}

void textureBase::setOpen(bool a)
{
	open=a;
}

bool textureBase::isOpen()
{
	return open;
}

const char *textureBase::getInfo()
{
	return info;
}

void textureBase::setInfo(char *t)
{
	if (info) free( (void *)info);
	info=strdup(t);
}

void textureBase::setParent(textureBase *t)
{
	parent=t;
}

textureBase *textureBase::getParent()
{
	return parent;
}

const char **textureBase::getXPM()
{
	if (subitems==false) return TBunknownPic;
	return TBYellowFolderPic;
}

textureBase *textureBase::getElementByType(ttyp t)
{
textureBase *tb=getFirstElement();
	if (!tb) return NULL;
	if (getType()==TEXTUREBOOK) return NULL;
	if (t==getType()) return this;
	while (tb!=NULL) {
		if ((tb->getType()==t)&&(tb->active()==true)) return tb;
		if ((tb->hasSubItems()==true)&&(tb->getType()!=TEXTUREBOOK)) {
			textureBase *tb2=tb->getElementByType(t);
			if (tb2) return tb2;
		}
		tb=getNextElement();
	}
	return NULL;
}


textureBase *textureBase::getFirstElement()
{
	return NULL;
}

textureBase *textureBase::getNextElement()
{
	return NULL;
}

void textureBase::addElement(textureBase *a, textureBase *b)
{
}

int textureBase::exportPOV(FILE *f,int a, int b, int c,bool d)
{
	return 0;
}

bool textureBase::isEqual(textureBase *t)
{
	if ((name)&&(!t->getName()) ) return false;
	if ((!name)&&(t->getName()) ) return false;

	if (!(strcmp(name,t->getName()))) return true;
	return false;
}

const char *textureBase::getPath()
{
	char *buf=new char[512];
	
	strcpy(buf,name);
	if (parent==NULL) {
		return buf;
	} else {	
		strcat(buf,"/");
		strcat(buf,parent->getPath() );
		return buf;
	}
}

bool textureBase::active()
{
	return Active;
}

void textureBase::setActive(bool a, textureBase *t)
{
	Active=a;
}

bool textureBase::hasSubItems()
{
	return subitems;
}

void textureBase::setSubItems(bool a)
{
	subitems=a;
}

bool textureBase::canAdd(textureBase *t)
{
	return false;
}

void textureBase::add(textureBase *what)
{
	return;
}

int textureBase::load(media *m,int l)
{

	name=readName();
	m->read(&typ,sizeof(int));
	m->read(&Active,sizeof(bool));
	return 0;
}

int textureBase::save(media *m)
{

chunk c;

	c.setMedia(m);
	c.writeChunk("BASE");

		writeName(name);
		m->write(&typ,sizeof(int));
		m->write(&Active,sizeof(bool));
	c.writeChunkLen();
	return 0;
}

void textureBase::alloc()
{
	locks++;
}

bool textureBase::isLocked()
{
	if (locks>0) return true;
	return false;
}

void textureBase::deAlloc()
{
	locks--;
	if (locks<0) locks=0;
}

void textureBase::remove(textureBase *)
{
}

void textureBase::setName(const char *n)
{
textureBase *tb;
char buffer[1024];
char buffer1[1024];

int c=0;
	if (n==NULL) return;
	if (name) free( (void*)name);
	if (parent==NULL) {
		name=strdup(n);
		//printf("ERROR GETTING PARENT %s ! (textureBase)",name);
		return;
	}
	tb=parent->getFirstElement();

	if (tb) {
		sprintf(buffer1,"%s",n );
		sprintf(buffer,"%s",n );
	}

	while (tb!=NULL) {
		if ((!(strcmp(tb->getName(),buffer)))&&(tb!=this) ) {
			c++;
			sprintf(buffer,"%s.%d",buffer1,c);	
		}
		tb=parent->getNextElement();
	}
	if (c==0) name=strdup(n);
	else name=strdup(buffer);
	
}

void textureBase::setPtr(const char *n)
{
	if (ptr) free( (void*)ptr);
	ptr=strdup(n);
}

ttyp textureBase::getType()
{
	return typ;
}	

const char *textureBase::getPtr()
{
	return ptr;
}

const char *textureBase::getName()
{
	return name;
}

textureBase::~textureBase()
{
	if (name) free( (void *)name);
	if (info) free( (void *)info);
	if (author) free ( (void *)author );
	if (description) free ( (void *)description );
}

