/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** texturelibrary.h
*/
#ifndef __TEXTURELIBRARY_H__
#define __TEXTURELIBRARY_H__

#include <chunk.h>
#include <list.h>
#include "texturebook.h"

class TextureLibrary :public textureBase
{

protected:
	list<textureBase *>		booklist;
	int num;
public:



	TextureLibrary();
	~TextureLibrary();

	void remove(textureBase *);
	void add(textureBase *);
	bool canAdd(textureBase *);
	
	void addElement(textureBase *,textureBase *where=NULL);

	void insertLibrary(TextureLibrary *);

	textureBase *getFirstElement();
	textureBase *getNextElement();

	texture* findTextureStruct(texture*);

	texture *findTexture(const char *n);
	texture *findTexturePath(const char*);
	
	int	load(media*,int);
	int	load(media*);
	int	save(media*);

	int	saveLib(media*);
 	int 	exportPOV(FILE *fp,int tab,int tabsize, int a,bool dummy);

};


#endif


