/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** misc.h
*/
#ifndef __MISC_H__
#define __MISC_H__

//
// debug stuff
//

#ifdef DEBUG_CALL
#define dbcall(a)	{  printf("%s %i call: %s\n",__FILE__,__LINE__,#a); (a); }
#else
#define dbcall(a) {(a);}
#endif

#ifdef DEBUG_EVAL
#define dbeval(a)	{  printf("%s %i eval: %s = %i\n",__FILE__,__LINE__,#a,a); }
#else
#define dbeval(a) {}
#endif

#ifdef DEBUG_FREE
#define free(a)	{ call( free(a));}
#endif

#ifdef DEBUG_HERE
#define dbhere()	{  printf("%s %i\n",__FILE__,__LINE__); }
#else
#define dbhere() {}
#endif

#define MIN(a,b)	((a)<(b)?(a):(b))
#define MAX(a,b)	((a)>(b)?(a):(b))

#define MIN3(a,b,c)	(MIN(a,MIN(b,c)))
#define MAX3(a,b,c)	(MAX(a,MAX(b,c)))

#ifndef PI
#define PI			3.1415926536
#endif

#ifndef FALSE
#define FALSE			0
#endif

#ifndef TRUE
#define TRUE			!FALSE
#endif


#define printTab(a,b)	{ int i; for(i = 0;i < (b);i++) fprintf((a)," ");}

#endif



