/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** main.cpp
*/

#include <version.h>

#include <kapp.h>

#include "mainwin.h"

KApplication	*k4deapp;

int	main(int argc,char **argv)
{
	MainWin	*win;

	k4deapp = new KApplication(argc,argv,PROGNAME);
	if ( k4deapp->isRestored() )
	{
		int n = 1;

		while (KTMainWindow::canBeRestored(n))
		{	
			MainWin *tl = new MainWin();
			tl->restore(n);
			n++;
		}

	} 
	else
	{

		win = new MainWin();

		k4deapp->setMainWidget(win);

		win->resize(700,500);
		win->setMaximumSize(3000,1500);
		win->setMinimumSize(500,200);

		win->show();
	}


	return k4deapp->exec();
}

