/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** worldtree.h
*/
#ifndef __WORLDTREE_H__
#define __WORLDTREE_H__

#include <qwidget.h>
#include <qpixmap.h>

#include <classes.h>
#include <objects.h>
#include <texture.h>
#include <texturelibrary.h>
#include <view.h>

#include "../widgets/treelist.h"


class WorldTree : public TreeList
{
	Q_OBJECT
protected:
	QPixmap		*pixmap[50];

	world		*worldptr;
	base		*capptr;

public:
	WorldTree(QWidget*,char *name = 0L);
	~WorldTree();

	int	load(const char*);
	int	save(const char*);
	int	empty();

	void	dump();

	void	draw();

	int	exportPOV(const char *fn,view*,int anim = 0);

	int	addX(base*);

	void	addObject();
	void	addCSG();
	void	addBlob();
	void	addRef();
	void	addSphere();
	void	addCylinder();
	void	addBox();
	void	addMesh();
	void	addCone();
	void	addPlane();
	void	addTorus();
	void	addRefPtr();
	void	addTriangle();
	void	addHeightfield();
	void	addText();

	void	addLightPoint();
	void	addSpotLight();
	void	addAreaLight();

	void	addCamera();

protected:
	virtual void	dragEnterEvent(QDragEnterEvent *de);
	virtual void	dragLeaveEvent(QDragLeaveEvent *de);
	virtual void	dragMoveEvent(QDragMoveEvent *de);
	virtual void	dropEvent(QDropEvent *de);

	virtual void	startDragCopy(QListViewItem *item,QWidget *dragsource);
	virtual void	startDragMove(QListViewItem *item,QWidget *dragsource);

private:
	void	layout();

	void	createWidgets();
	void	createTree();
	void	createTree(base *,QListViewItem*,int);

	void	paintEvent(QPaintEvent *);
	void	resizeEvent(QResizeEvent *);
        void	changeTexture(texture*,QListViewItem*);

public slots:
	void	popupMenu(QListViewItem*,int,int);
	void	rename(QListViewItem*,const char *newname);
	void	remove(QListViewItem*);
	void	copy(QListViewItem*);
	void	cut(QListViewItem*);
	void	paste(QListViewItem*);
	void	getSelected(QListViewItem*);
	void	setTexture(texture*);
	void	animScript(QListViewItem*);
	void	setWorld(world*);
	void	setTexture(QString,texture*);
	void	changeTexture(texture*);

signals:
	void	redraw();
	void	changeWorld(world*);
	void	setTextureLibrary(TextureLibrary*);
	void	setObjectTexture(QString,int);
	void	setSelected(base*);
};

#endif

