/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** bumpmapdialog.h
*/
#ifndef __BUMPMAPDIALOG_H__
#define __BUMPMAPDIALOG_H__


#include <qwidget.h>
#include <qgroupbox.h>
#include <qpainter.h>
#include <qcolor.h>
#include <kcolorbtn.h>
#include <qdialog.h>
#include <qlineedit.h>
#include <qcheckbox.h>

#include <color.h>
#include <qcolor.h>
#include <qcheckbox.h>
#include "../misc/spinbox.h"
#include "../widgets/getfilewidget.h"
#include "../../3d/textures/bumpmap.h"


class BumpMapWidget : public QWidget
{
Q_OBJECT
protected:
	GetFileWidget		*filewidget;
        QLineEdit		*name;
	QComboBox		*mapping,*interpolate;
	QLabel			*maplabel,*bslabel,*uclabel,*nlabel,*interpolatelabel;
	QCheckBox		*active;
	SpinBox			*bumpsize;
	QCheckBox		*usecolor,*once;
	bumpMap			*bu;
	bitmapmodifier		*bmm;

public:

	BumpMapWidget(QWidget *p, bumpMap *);
	~BumpMapWidget();
	void getBumpMap();

protected:
	void	paintEvent(QPaintEvent*);

};

//--------------------------------------------------------

class BumpMapDialog : public QDialog
{
Q_OBJECT
protected:

	QPushButton		*ok,*cancel;
	BumpMapWidget		*pw;

public:

	BumpMapDialog(QWidget *p, bumpMap *);
	~BumpMapDialog();

protected:
	void	paintEvent(QPaintEvent*);
public slots:
	void okayPressed();
	void cancelPressed();
};

#endif
