/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** colormapdialog.cpp
*/
#include "colormapdialog.h"
#include "colormapdialog.moc"


#include "patternmodifierdialog.h"

ColorMapWidget::ColorMapWidget(QWidget *parent,colorMap *c) :
	QWidget(parent,"ColorMapWidget")
{

textureBase *tb;
QWidget *w;
int x;
	co=c;

	label4=NULL;
	tw=NULL;
	tbw=NULL;
	turbulence=NULL;
	transformations=NULL;
	pmd=NULL;

	tab=new TabWidget(this,"Color:",1);

	tb=co->getFirstElement();
	while (tb!=NULL) {

		switch(tb->getType()) {
			case COLORENTRY:
				w=(QWidget *)new ColorEntryWidget(NULL,(colorEntry *)tb);
	     			colorwidget.append( (ColorEntryWidget *)w );
				widgetlist.append (w);
				x=widgetlist.length()-1;
				tab->addWidget(w,x,tb->getName() );

			break;
			case TRANSFORMATIONS:
				transformations=new QPushButton("Transformations...",this);
				connect (transformations,SIGNAL(clicked()),this,SLOT(transformationsPressed()) );
				tw=new TransformationsWidget(NULL,(Transformations*)tb );
				tw->setCaption("Transformations");
			break;
			case TURBULENCEMODIFIER:
				turbulence=new QPushButton("Turbulence...",this);
				connect (turbulence,SIGNAL(clicked()),this,SLOT(turbulencePressed()) );
				tbw=new TurbulenceWidget(NULL,(Turbulence*)tb );
				tbw->setCaption("Turbulence");

			break;
			default:
			break;
		}

		tb=co->getNextElement();
	}

	line=new QLineEdit(this);
	line->setText(co->getName());
	n=new QLabel("Name:",this);


	active=new QCheckBox("Active",this);
	active->setChecked(co->active() );

	add=new QPushButton("Add Element",this);
	connect(add,SIGNAL(clicked()),this,SLOT(addClicked()) );

	if (colorwidget.length()==0) label4=new QLabel("no entrys in map ! ",this);	
	
	pmd=new PatternModifierWidget(this,co->getMapModifier() );

	resize(200,300);
	
}

ColorMapWidget::~ColorMapWidget()
{
}

void ColorMapWidget::addClicked()
{
colorEntry *c=new colorEntry(co);
QWidget *w;
int x;
	if (label4) {
		delete tab;
		tab=new TabWidget(this,"Color:",1);
		tab->setGeometry(10,185,320,190);
		tab->show();
		delete label4;
		label4=NULL;
	}
	co->add(c);
	w=(QWidget *)new ColorEntryWidget(NULL,(colorEntry *)c);
	colorwidget.append( (ColorEntryWidget *)w );
	widgetlist.append (w);
	x=widgetlist.length()-1;
	tab->addWidget(w,x,c->getName() );
	tab->select(x);
}

void ColorMapWidget::getColorMap()
{
int i;
	if (tw) tw->getTransformations();
	if (tbw) tbw->getTurbulence();
	co->setName( line->text());
	pmd->getPatternModifier();
	for (i=0;i<colorwidget.length();i++) if (colorwidget[i]) colorwidget[i]->getColorEntry();	
	co->setActive(active->isChecked(),NULL);
}

void ColorMapWidget::transformationsPressed()
{
	tw->resize(200,440);
	tw->setMinimumSize(200,440);
	tw->exec();
}

void ColorMapWidget::turbulencePressed()
{
	tbw->resize(270,170);
	tbw->setMinimumSize(270,170);
	tbw->exec();
}

void ColorMapWidget::paintEvent(QPaintEvent* qp)
{

	add->setGeometry(10,40,110,25);

	n->setGeometry(10,10,50,25);
	line->setGeometry(65,10,150,25);

	active->setGeometry(220,10,60,25);
	
	if(pmd) pmd->setGeometry(10,80,320,100);

	//if (transformations) transformations->setGeometry(20,160,110,25);
	//if (turbulence) turbulence->setGeometry(150,160,110,25);

        if (label4) {
		label4->setGeometry(width()/2-140,240,280,25);
		 tab->setGeometry(-400,-300,320,210);
	}
	else tab->setGeometry(10,185,320,190);

	QWidget::paintEvent(qp);
}

//------------------------------------------------------------------------

ColorMapDialog::ColorMapDialog(QWidget *parent,colorMap *co) :
	QDialog(parent,"ColorMapDialog",true)
{

	setCaption("ColorMap");

	ok=new QPushButton("Okay",this);
	cancel=new QPushButton("Cancel",this);

	pw=new ColorMapWidget(this,co);

	connect (ok,SIGNAL(pressed()),this,SLOT(okayPressed()) );
	connect (cancel,SIGNAL(pressed()),this,SLOT(cancelPressed()) );

	resize(340,410);
	setMinimumSize(340,410);
	setMaximumSize(340,410);
	
}

ColorMapDialog::~ColorMapDialog()
{
}


void ColorMapDialog::cancelPressed()
{
	QDialog::done(0);
}

void ColorMapDialog::okayPressed()
{
	pw->getColorMap();
	QDialog::done(1);
}

void ColorMapDialog::paintEvent(QPaintEvent* qp)
{
	int w=width();
	int h=height();


	
	cancel->setGeometry(w-65,h-30,60,25);
	ok->setGeometry(w-65-45,h-30,40,25);

	pw->setGeometry(0,0,w,h-35);

	QDialog::paintEvent(qp);
}



