/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** finishdialog.cpp
*/
#include "finishdialog.h"
#include "finishdialog.moc"



FinishWidget::FinishWidget(QWidget *parent,finish *f) :
	QWidget(parent,"FinishWidget")
{
color *col;
textureBase *tb;

	fi=f;

	setCaption("Finish");	
	transformations=NULL;
	turbulence=NULL;

	tb=fi->getFirstElement();
	while (tb!=NULL) {

		switch(tb->getType()) {
			case TRANSFORMATIONS:
				transformations=new QPushButton("Transformations...",this);
				connect (transformations,SIGNAL(clicked()),this,SLOT(transformationsPressed()) );
				tw=new TransformationsWidget(NULL,(Transformations*)tb );
				tw->setCaption("Transformations");
			break;
			case TURBULENCEMODIFIER:
				turbulence=new QPushButton("Turbulence...",this);
				connect (turbulence,SIGNAL(clicked()),this,SLOT(turbulencePressed()) );
				tbw=new TurbulenceWidget(NULL,(Turbulence*)tb );
				tbw->setCaption("Turbulence");

			break;
			default:
			break;
		}
		tb=fi->getNextElement();
	}		

	name=new QLineEdit(this);
	name->setText(fi->getName());

	namelabel=new QLabel("Name:",this);

	tab=new TabWidget(this);

	page1=new QWidget(this);
	page2=new QWidget(this);
	page3=new QWidget(this);

	col=fi->getAmbient();
	qc.setRgb( (int)(col->red()*255.0), (int)(col->green()*255.0), (int)(col->blue()*255.0) );
	ambient=new KColorButton(qc,page1);
        ambientlabel=new QLabel("Ambient:",page1);
	diffuse=new SpinBox(page1,"Diffuse:",fi->getDiffuse() );
	brilliance=new SpinBox(page1,"Brilliance:",fi->getBrilliance() );
	

	phong=new SpinBox(page2,"Phong:",fi->getPhong() );
	phongsize=new SpinBox(page2,"Phongsize:",fi->getPhongSize() );
	specular=new SpinBox(page2,"Specular:",fi->getSpecular() );
	roughness=new SpinBox(page2,"Roughness:",fi->getRoughness() );
	metall=new QCheckBox("Metallic",page2);
	metall->setChecked(fi->getMetallic());

	reflection=new SpinBox(page3,"Reflection:",fi->getReflection() );		
	iridlabel=new QLabel("Irid:",page3);
	iridturb=new SpinBox(page3,"Turbulence:",fi->getIridTurbulence() );
	iridthick=new SpinBox(page3,"Thickness:",fi->getIridThickness() );
	iridamount=new SpinBox(page3,"Turbulence:",fi->getIridAmount() );

	connect (transformations,SIGNAL(clicked()),this,SLOT(transformationsPressed()) );
	connect (turbulence,SIGNAL(clicked()),this,SLOT(turbulencePressed()) );

	tab->addWidget(page1,0,"Ambient");
	tab->addWidget(page2,1,"Highlights");
	tab->addWidget(page3,2,"Reflections");
	tab->select(0);
	
	active=new QCheckBox("Active",this);
	active->setChecked( fi->active() );

}

FinishWidget::~FinishWidget()
{
}


void FinishWidget::getFinish()
{
color *col = new color(NULL);

	col->setRed( (double)  (ambient->color().red()/255.0)   );
	col->setGreen( (double)(ambient->color().green()/255.0) );
	col->setBlue( (double) (ambient->color().blue()/255.0)  );

	fi->setActive(active->isChecked(),NULL );

	fi->setAmbient(col);	
	fi->setBrilliance(brilliance->getValue() );
	fi->setDiffuse(diffuse->getValue() );

	fi->setPhong(phong->getValue() );
	fi->setPhongSize(phongsize->getValue() );
	fi->setSpecular(specular->getValue() );
	fi->setRoughness(roughness->getValue() );
	fi->setMetallic(metall->isChecked());

	fi->setReflection(reflection->getValue() );
	fi->setIridTurbulence(iridturb->getValue() );
	fi->setIridThickness(iridthick->getValue() );
	fi->setIridAmount(iridamount->getValue() );
	
	fi->setName(name->text() );

	if (turbulence) tw->getTransformations();
	if (transformations) tbw->getTurbulence();
}

void FinishWidget::transformationsPressed()
{

	tw->resize(180,440);
	tw->setMinimumSize(180,440);

	tw->exec();
}
void FinishWidget::turbulencePressed()
{


	tbw->resize(270,170);
	tbw->setMinimumSize(270,170);

	tbw->exec();
}

int FinishWidget::width()
{
	return 420;
}

int FinishWidget::height()
{
	return 260;
}

void FinishWidget::paintEvent(QPaintEvent* qp)
{
	int w=width();
	int h=height();

	namelabel->setGeometry(70,10,50,25);
	name->setGeometry(125,10,180,25);

        active->setGeometry(310,10,110,25);

	tab->setGeometry(10,50,w/1.5-15,200);
	if (transformations) transformations->setGeometry(w/1.5+20,100,110,25);
	if (turbulence) turbulence->setGeometry(w/1.5+20,130,110,25);

	w=page1->width();
	h=page1->height();
	ambientlabel->setGeometry(10,10,50,25);
	ambient->setGeometry(75,10,50,25);
	diffuse->setGeometry(10,60,120,25);
	brilliance->setGeometry(10,95,120,25);

	w=page2->width();
	h=page2->height();
	phong->setGeometry(10,10,120,25);
	phongsize->setGeometry(10,40,120,25);
	specular->setGeometry(40,80,140,25);	
	roughness->setGeometry(40,110,140,25);	
	metall->setGeometry(40,140,140,25);	

	w=page3->width();
	h=page3->height();
        reflection->setGeometry(10,10,160,25);
	iridlabel->setGeometry(20,50,160,25);
	iridturb->setGeometry(30,85,160,25);	
	iridthick->setGeometry(30,115,160,25);	
	iridamount->setGeometry(30,145,160,25);	
	
	QWidget::paintEvent(qp);
}



//----------------------------------------------------------

FinishDialog::FinishDialog(QWidget *parent,finish *f) :
	QDialog(parent,"FinishDialog",true)
{

	ok=new QPushButton("Okay",this);
	cancel=new QPushButton("Cancel",this);

	nw=new FinishWidget(this,f);

	connect (ok,SIGNAL(pressed()),this,SLOT(okayPressed()) );
	connect (cancel,SIGNAL(pressed()),this,SLOT(cancelPressed()) );

	resize(nw->width(),nw->height()+30);
	setMinimumSize(nw->width(),nw->height()+30);
	setMaximumSize(nw->width(),nw->height()+30);

}


void FinishDialog::okayPressed()
{  	
	nw->getFinish();   //Widgetwerte in Pointer sichern
	QDialog::done(1);
}

void FinishDialog::cancelPressed()
{
	QDialog::done(0);
}

FinishDialog::~FinishDialog()
{
}

void FinishDialog::paintEvent(QPaintEvent* qp)
{
	int w=width();
	int h=height();


	cancel->setGeometry(w-65,h-30,60,25);
	ok->setGeometry(w-65-45,h-30,40,25);
	nw->setGeometry(0,0,w,h-35);

	QDialog::paintEvent(qp);
}

