/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** imagemapdialog.cpp
*/
#include "imagemapdialog.h"
#include "imagemapdialog.moc"




ImageMapWidget::ImageMapWidget(QWidget *parent,imageMap *i) :
	QWidget(parent,"ImageMapDialog")
{

	im=i;
	bmm=im->getModifier();	

	filewidget=new GetFileWidget(this,"File:",im->getImageMapFilename(),1);

	filter=new SpinBox(this,"Filter:",im->getImageMapFilterValue() );
	transmit=new SpinBox(this,"Transmit:",im->getImageMapTransmitValue() );


	name=new QLineEdit(this);
	name->setText(i->getName());
	nameLabel=new QLabel("Name:",this);

	mapping=new QComboBox(this);
	mapping->insertItem("planar");
	mapping->insertItem("spherical");
	mapping->insertItem("(reserved#1)");
	mapping->insertItem("(reserved#2)");
	mapping->insertItem("donut/torus");
	mapping->setCurrentItem(bmm->getMapType() );	

	maplabel=new QLabel("Mapping:",this);

	once=new QCheckBox("Once",this);
	if (bmm->getOnce()==1) once->setChecked(true);
	else once->setChecked(false);

	interpolate=new QComboBox(this);
	interpolate->insertItem("none");
	interpolate->insertItem("bilinear");
	interpolate->insertItem("normalized");
	switch(bmm->getInterpolate()) {
		case 0:interpolate->setCurrentItem(0);
		break;
		case 2:interpolate->setCurrentItem(1);
		break;
		case 4:interpolate->setCurrentItem(2);
		break;
	}
	
	interpolatelabel=new QLabel("Interpolation:",this);
	active=new QCheckBox("Active",this);
	active->setChecked(im->active() );
}

ImageMapWidget::~ImageMapWidget()
{
}

void ImageMapWidget::getImageMap()
{
	im->setImageMapFilterValue(filter->getValue());
	im->setImageMapTransmitValue(transmit->getValue());
	im->setImageMapFilename( (char *)filewidget->getFilename());
	im->setImageMapFiletype( (char *)filewidget->getImageType());

	bmm->setMapType(mapping->currentItem());
	if (once->isChecked()) bmm->setOnce();
	else bmm->unSetOnce();
	switch(interpolate->currentItem() ) {
		case 0: bmm->setInterpolate(0);
		break;
		case 1:bmm->setInterpolate(2);
		break;
		case 2:bmm->setInterpolate(4);
		break;
	}
	im->setName(name->text());	
	im->setActive( active->isChecked(),NULL);
}

int ImageMapWidget::height()
{	
	return 170;
}

int ImageMapWidget::width()
{	
	return 280;
}

void ImageMapWidget::paintEvent(QPaintEvent* qp)
{
	int w=width();
	//int h=height();
	
	nameLabel->setGeometry(10,10,50,25);
	name->setGeometry(65,10,150,25);
	
	active->setGeometry(220,10,60,25);

	filewidget->setGeometry(10,40,w-20,25);
	
	filter->setGeometry(10,70,80,25);
	transmit->setGeometry(100,70,100,25);
	once->setGeometry(205,70,50,25);

	maplabel->setGeometry(10,105,55,25);
	mapping->setGeometry(95,105,110,25);
	
	interpolatelabel->setGeometry(10,135,85,25);
	interpolate->setGeometry(95,135,110,25);	
	
	QWidget::paintEvent(qp);
}
//------------------------------------------------------------------------

ImageMapDialog::ImageMapDialog(QWidget *parent,imageMap *i) :
	QDialog(parent,"ImageMapDialog",true)
{

	setCaption("Imagemap");

	ok=new QPushButton("Okay",this);
	cancel=new QPushButton("Cancel",this);

	pw=new ImageMapWidget(this,i);

	connect (ok,SIGNAL(pressed()),this,SLOT(okayPressed()) );
	connect (cancel,SIGNAL(pressed()),this,SLOT(cancelPressed()) );

	resize(pw->width(),pw->height() );
	setMinimumSize(pw->width(),pw->height());
	setMaximumSize(pw->width(),pw->height());
	
}

ImageMapDialog::~ImageMapDialog()
{
}


void ImageMapDialog::cancelPressed()
{
	QDialog::done(0);
}

void ImageMapDialog::okayPressed()
{
	pw->getImageMap();
	QDialog::done(1);
}

void ImageMapDialog::paintEvent(QPaintEvent* qp)
{
	int w=width();
	int h=height();


	
	cancel->setGeometry(w-65,h-30,60,25);
	ok->setGeometry(w-65-45,h-30,40,25);

	pw->setGeometry(0,0,w,h-35);

	QDialog::paintEvent(qp);
}

