/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** normaldialog.h
*/
#ifndef __NormalDialog_H__
#define __NormalDialog_H__


#include <qwidget.h>
#include <qgroupbox.h>
#include <qpainter.h>
#include <qcolor.h>
#include <qcombobox.h>
#include <kcolorbtn.h>
#include <qdialog.h>
#include <qlineedit.h>
#include <qpopupmenu.h>

#include <color.h>
#include "../../3d/textures/normal.h"
#include "../misc/vectorwidget.h"
#include "../widgets/tabwidget.h"
#include <qcolor.h>
#include <qlabel.h>
#include <qframe.h>
#include <qcheckbox.h>

#include "colorwidget.h"
#include "transformationswidget.h"
#include "colorlistdialog.h"
#include "bumpmapdialog.h"
#include "turbulencewidget.h"


class NormalWidget : public QWidget
{
Q_OBJECT
protected:
	normal  *nor;

	TransformationsWidget *tw;
	TurbulenceWidget *tbw;

	TabWidget	*tab;

	QPushButton		*transformations,*turbulence,*addElement;
	QLineEdit		*line1;
	QCheckBox		*active;
	
	QColor			quickColor;
	QLabel			*label1,*label3,*label4;

	list<QWidget *>			widgetlist;
	list<BumpMapWidget *>		bumpwidget;
	QWidget		*emptywidget;


public:

	NormalWidget(QWidget *p, normal *);
	~NormalWidget();

	void getNormal();

protected:
	void	paintEvent(QPaintEvent*);
protected slots:
	void transformationsPressed();
	void turbulencePressed();
	void addPressed();
};

//---------------------------------------------------------

class NormalDialog : public QDialog
{
Q_OBJECT
protected:
	QPushButton		*ok,*cancel;
	NormalWidget		*nw;


public:

	NormalDialog(QWidget *p, normal *);
	~NormalDialog();

protected:
	void	paintEvent(QPaintEvent*);

protected slots:
	void okayPressed();
	void cancelPressed();

};


#endif
