/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** patternmodifierdialog.cpp
*/
#include "patternmodifierdialog.h"
#include "patternmodifierdialog.moc"

#include "../widgets/sliderwidget.h"

PatternModifierWidget::PatternModifierWidget(QWidget *parent,patternmodifier *pm) :
	QWidget(parent,"PatternModifierWidget")
{


	pmod=pm;

	tab=new TabWidget(this,"Pattern:",1);
	page0=new QWidget();
	noOpt=new QLabel("No Options avaiable",page0);


	tab->addWidget(page0,0,"Wrinkles");


	agatep=new QWidget();
	tab->addWidget(agatep,1,"Agate");
	agateturb=new SpinBox(agatep,"Agate Turbulence:",pmod->getAgateTurbulence() );


	tab->addWidget(page0,2,"Average");
	tab->addWidget(page0,3,"Boxed");
	tab->addWidget(page0,4,"Bozo");
	tab->addWidget(page0,5,"Bumps");
	tab->addWidget(page0,6,"Crackle");
	tab->addWidget(page0,7,"Cylindrical");

	densityp=new QWidget();
	tab->addWidget(densityp,8,"Density");
	density=new GetFileWidget(densityp,"Densitymap:",pmod->getDensityMap(),0);
	dinter=new QCheckBox("Interpolate",densityp);
	dinter->setChecked(pmod->getDensityInterpolation() );


	tab->addWidget(page0,9,"Dents");

	gradientp=new QWidget();
	tab->addWidget(gradientp,10,"Gradient");
	gradvek=new VectorWidget(gradientp,"Gradient");
	gradvek->setVector(pmod->getGradient() );


	tab->addWidget(page0,11,"Granite");
	tab->addWidget(page0,12,"Leopard");

	mandelp=new QWidget();
	tab->addWidget(mandelp,13,"Mandel");
	mandelit=new SliderWidget(mandelp,"Iterations:",pmod->getIterations(),0,50 );

	tab->addWidget(page0,14,"Marble");
	tab->addWidget(page0,15,"Onion");	
	tab->addWidget(page0,16,"Planar");


	quiltedp=new QWidget();
	tab->addWidget(quiltedp,17,"Quilted");
	con0=new SpinBox(quiltedp,"Control 0",pmod->getControl0() );
	con1=new SpinBox(quiltedp,"Control 1",pmod->getControl1() );

	radialp=new QWidget();
	tab->addWidget(radialp,18,"Radial");
	radialfreq=new SpinBox(radialp,"Frequency:",pmod->getRadialFrequency() );

	tab->addWidget(page0,19,"Ripples");

	tab->addWidget(page0,20,"Spherical");

	spiral1p=new QWidget();
	tab->addWidget(spiral1p,21,"Spiral 1");
	arms1=new SpinBox(spiral1p,"Arms:",pmod->getSpiral1Arms() );

	spiral2p=new QWidget();
	tab->addWidget(spiral2p,22,"Spiral 2");
	arms2=new SpinBox(spiral2p,"Arms:",pmod->getSpiral2Arms() );

	tab->addWidget(page0,23,"Waves");
      	tab->addWidget(page0,24,"Wood");


	tab->select(pmod->getMode());

}

PatternModifierWidget::~PatternModifierWidget()
{
}


void PatternModifierWidget::getPatternModifier()
{

	pmod->setMode( tab->getSelected() );

	pmod->setAgateTurbulence(agateturb->getValue() );
	pmod->setControl0(con0->getValue() );
	pmod->setControl1(con1->getValue() );
	pmod->setRadialFrequency(radialfreq->getValue() );
	pmod->setSpiral1Arms(arms1->getValue() );
	pmod->setSpiral2Arms(arms2->getValue() );
	pmod->setIterations(mandelit->getValue() );
	pmod->setGradient( gradvek->getVector() );
	pmod->setDensityInterpolation(dinter->isChecked() );
	pmod->setDensityMap(density->getFilename() );
	
}

void PatternModifierWidget::paintEvent(QPaintEvent* qp)
{
	int w=width();
	int h=height();

	tab->setGeometry(0,0,w-10,h-10);

	w=tab->width()-10;
	h=tab->height()-10;
	noOpt->setGeometry(w/2-70,h/2-12,140,25);

	arms1->setGeometry(w/2-80,20,160,25);
	arms2->setGeometry(w/2-80,20,160,25);

	con0->setGeometry(w/2-80,20,160,25);
	con1->setGeometry(w/2-80,50,160,25);

	agateturb->setGeometry(w/2-80,20,160,25);
	radialfreq->setGeometry(w/2-80,20,160,25);

	gradvek->setGeometry(w/2-80,20,140,110);

	density->setGeometry(5,20,260,25);
	dinter->setGeometry(w/2-80,50,90,20);

	mandelit->setGeometry(w/2-80,20,200,25);

	QWidget::paintEvent(qp);
}


//----------------------------------------------------------

PatternModifierDialog::PatternModifierDialog(QWidget *parent,patternmodifier *n) :
	QDialog(parent,"PatternModifierDialog",true)
{

#ifdef DEBUG
	printf("entering PatternmodifierDialog KOnstruktor\n");
#endif

        setCaption("Patterns");
	
	ok=new QPushButton("Okay",this);
	cancel=new QPushButton("Cancel",this);

	nw=new PatternModifierWidget(this,n);

	connect (ok,SIGNAL(clicked()),this,SLOT(okayPressed()) );
	connect (cancel,SIGNAL(clicked()),this,SLOT(cancelPressed()) );

	resize(300,220);
	setMinimumSize(300,220);
	setMaximumSize(300,220);
#ifdef DEBUG
	printf("exiting PatternmodifierDialog KOnstruktor\n");
#endif
}


void PatternModifierDialog::okayPressed()
{  	
	nw->getPatternModifier();   //Widgetwerte in Pointer sichern
	QDialog::done(1);
}

void PatternModifierDialog::cancelPressed()
{
	QDialog::done(0);
}

PatternModifierDialog::~PatternModifierDialog()
{
}

void PatternModifierDialog::paintEvent(QPaintEvent* qp)
{
	int w=width();
	int h=height();
                       	
	cancel->setGeometry(w-65,h-30,60,25);
	ok->setGeometry(w-65-45,h-30,40,25);
	nw->setGeometry(0,0,w,h-35);

	QDialog::paintEvent(qp);
}

