/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** pigmentdialog.cpp
*/
#include "pigmentdialog.h"

#include "colorwidget.h"
#include "transformationswidget.h"
#include "colorlistdialog.h"
#include "colormapdialog.h"
#include "imagemapdialog.h"
#include "turbulencewidget.h"
#include "patternmodifierdialog.h"



#include "pigmentdialog.moc"




PigmentWidget::PigmentWidget(QWidget *parent,pigment *p) :
	QWidget(parent,"PigmentWidget")
{
textureBase *tb;
int x,a;
QWidget *w;

	pig=p;	
	a=0;

	tab=new TabWidget(this,"Element:",1);

	quickColor.setRgb( (int)(pig->getQuickColor(NULL)->red()*255.0), (int)(pig->getQuickColor(NULL)->green()*255.0), (int)(pig->getQuickColor(NULL)->blue()*255.0) ); //,(int)(col->transparency()*255) );
	cbt1=new KColorButton(quickColor,this);

	label2=new QLabel("Name:",this);
	line1=new QLineEdit(this);
	line1->setText(pig->getName() );

	label1=new QLabel("Quick Color",this);

	transformations=NULL;
	turbulence=NULL;
	emptywidget=NULL;
	tw=NULL;
	tbw=NULL;

	tb=p->getFirstElement();
	while (tb!=NULL) {
        	
		switch(tb->getType()) {
			case COLOR:
				w=(QWidget *)new ColorWidget(NULL,(color *)tb);
	     			colorwidget.append( (ColorWidget *)w );
				widgetlist.append (w);
				x=widgetlist.length()-1;
				tab->addWidget(w,x,tb->getName() );
				if (tb->active()==true) a=x;

			break;
			case IMAGEMAP:
				w=(QWidget *)new ImageMapWidget(NULL,(imageMap *)tb);
				imagemapwidget.append( (ImageMapWidget *)w );
				widgetlist.append (w);
				x=widgetlist.length()-1;
				tab->addWidget(w,x,tb->getName());
				if (tb->active()==true) a=x;
        		break;
			case COLORLIST:
				w=new ColorListWidget(NULL,(colorList*)tb);
				colorlistwidget.append( (ColorListWidget *)w);
				widgetlist.append (w);
				x=widgetlist.length()-1;
				tab->addWidget(w,x,tb->getName());
				if (tb->active()==true) a=x;
			break;
			case COLORMAP:
				w=new ColorMapWidget(NULL,(colorMap*)tb);
				colormapwidget.append( (ColorMapWidget *)w);
				widgetlist.append (w);
				x=widgetlist.length()-1;
				tab->addWidget(w,x,tb->getName());
				if (tb->active()==true) a=x;
			break;

			case TRANSFORMATIONS:
				transformations=new QPushButton("Transformations...",this);
				connect (transformations,SIGNAL(clicked()),this,SLOT(transformationsPressed()) );
				tw=new TransformationsWidget(NULL,(Transformations*)tb );
				tw->setCaption("Transformations");
			break;
			case TURBULENCEMODIFIER:
				turbulence=new QPushButton("Turbulence...",this);
				connect (turbulence,SIGNAL(clicked()),this,SLOT(turbulencePressed()) );
				tbw=new TurbulenceWidget(NULL,(Turbulence*)tb );
				tbw->setCaption("Turbulence");

			break;
			default:
			break;
		}

		tb=p->getNextElement();
	}
	if (	(colorwidget.length()==0)&&
		(imagemapwidget.length()==0)&&
		(colorlistwidget.length()==0)&&
		(colormapwidget.length()==0)&&
		(colormapwidget==NULL)&&
		(pigmentlistwidget==NULL)&&
		(pigmentmapwidget==NULL) ) {
			emptywidget=new QWidget(tab);
			label4=new QLabel("Nothing to edit...",this);
	} else tab->select(a);

	addElement=new QPushButton("Add...",this);
	connect(addElement,SIGNAL(clicked()),this,SLOT(addPressed()) );
	active=new QCheckBox("Active",this);
	active->setChecked(pig->active() );
}

void PigmentWidget::addPressed()
{
QWidget *w;
int x;
textureBase *tb;
	Elements=new QPopupMenu(this);
	Elements->insertItem("Color",1);
	Elements->insertItem("Image",2);
	Elements->insertItem("Colormap",3);
	Elements->insertItem("Colorlist",4);
	switch(Elements->exec(QCursor::pos() )) {
		case 1:
			pig->add( (tb=new color(pig)) );
			w=(QWidget *)new ColorWidget(NULL,(color *)tb);
     			colorwidget.append( (ColorWidget *)w );
			widgetlist.append (w);
			x=widgetlist.length()-1;
			tab->addWidget(w,x,tb->getName() );
        		tab->select(x);
		break;
		case 2:
			pig->add((tb=new imageMap(pig)) );
			w=(QWidget *)new ImageMapWidget(NULL,(imageMap *)tb);
			imagemapwidget.append( (ImageMapWidget *)w );
			widgetlist.append (w);
			x=widgetlist.length()-1;
			tab->addWidget(w,x,tb->getName());
			tab->select(x);
		break;
		case 3:
			pig->add((tb=new colorMap(pig)) );
			w=new ColorMapWidget(NULL,(colorMap*)tb);
			colormapwidget.append( (ColorMapWidget *)w);
			widgetlist.append (w);
			x=widgetlist.length()-1;
			tab->addWidget(w,x,tb->getName());
			tab->select(x);
		break;
		case 4:
			pig->add( (tb=new colorList(pig)) );
			w=new ColorListWidget(NULL,(colorList*)tb);
			colorlistwidget.append( (ColorListWidget *)w);
			widgetlist.append (w);
			x=widgetlist.length()-1;
			tab->addWidget(w,x,tb->getName());
			tab->select(x);
		break;
		default:
		break;
	}
	delete Elements;
}


PigmentWidget::~PigmentWidget()
{
}

void PigmentWidget::getPigment()
{
color *clo=new color(NULL);
int i;

	clo->setRed((double)(cbt1->color().red()/255.0));
	clo->setGreen((double)(cbt1->color().green()/255.0));
	clo->setBlue((double)(cbt1->color().blue()/255.0));
	clo->setName( "QuickColorItem");
	pig->setQuickColor(clo);
	pig->setName(line1->text() );
	if (tw) tw->getTransformations();
	if (tbw) tbw->getTurbulence();

	for (i=0;i<colorwidget.length();i++) if (colorwidget[i]) colorwidget[i]->getColor();
	for (i=0;i<colorlistwidget.length();i++) if (colorlistwidget[i]) colorlistwidget[i]->getColorList();
	for (i=0;i<colormapwidget.length();i++) if (colorlistwidget[i]) colormapwidget[i]->getColorMap();
	for (i=0;i<imagemapwidget.length();i++) if (imagemapwidget[i]) imagemapwidget[i]->getImageMap();

	pig->setName(line1->text());
	pig->setActive(active->isChecked(),NULL );

}

void PigmentWidget::transformationsPressed()
{
	tw->resize(200,440);
	tw->setMinimumSize(200,440);
	tw->exec();
}

void PigmentWidget::turbulencePressed()
{
	tbw->resize(270,170);
	tbw->setMinimumSize(270,170);
	tbw->exec();
}

void PigmentWidget::paintEvent(QPaintEvent* qp)
{
	int w=width();
	int h=height();

	label1->setGeometry(15,5,70,25);
	cbt1->setGeometry(15,32,60,60);	

	label2->setGeometry(100,10,50,25);
	line1->setGeometry(155,10,160,25);

	if (emptywidget) label4->setGeometry(10,10,w-10,25);
	if (transformations) transformations->setGeometry(w/1.5+20,100,110,25);
	if (turbulence) turbulence->setGeometry(w/1.5+20,130,110,25);

	tab->setGeometry(15,65,w/1.5-10,h-85);	

	addElement->setGeometry(20+w/1.5,65,110,25);
        active->setGeometry(20+w/1.5,35,110,25);
	
	QWidget::paintEvent(qp);
}

//------------------------------------------------------------------------

PigmentDialog::PigmentDialog(QWidget *parent,pigment *p) :
	QDialog(parent,"PigmentDialog",true)
{

	ok=new QPushButton("Okay",this);
	cancel=new QPushButton("Cancel",this);

	pw=new PigmentWidget(this,p);

	connect (ok,SIGNAL(pressed()),this,SLOT(okayPressed()) );
	connect (cancel,SIGNAL(pressed()),this,SLOT(cancelPressed()) );

	resize(550,460);
	setMinimumSize(550,560);
	setMaximumSize(550,560);
	
}

PigmentDialog::~PigmentDialog()
{
}


void PigmentDialog::cancelPressed()
{
	QDialog::done(0);
}

void PigmentDialog::okayPressed()
{
	pw->getPigment();
	QDialog::done(1);
}

void PigmentDialog::paintEvent(QPaintEvent* qp)
{
	int w=width();
	int h=height();


	
	cancel->setGeometry(w-65,h-30,60,25);
	ok->setGeometry(w-65-45,h-30,40,25);

	pw->setGeometry(0,0,w,h-35);

	QDialog::paintEvent(qp);
}

