/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** previewwidget.cpp
*/
#include "previewwidget.h"
#include "previewwidget.moc"

PreviewWidget::PreviewWidget(QWidget *p,char *n) :
	QFrame(p,n)
{
	qp = new QPainter(this);

	setFrameStyle(WinPanel | Sunken);
	setLineWidth(2);
	setMidLineWidth(2);

	xo = 0;yo = 0;

	ppmfp = 0;
}

PreviewWidget::~PreviewWidget()
{
	delete qp;
}

void	PreviewWidget::render(texture *t)
{
	char	str[16];
	FILE	*fp;

	if((fp = fopen("data/texture/texture.pov","w")) == 0) return;
	t->exportPOV(fp,0,4,0);
	fclose(fp);

	system("rm -f data/texture/preview.ppm");

	proc.clearArguments();

	proc << "povray";
	sprintf(str,"+W%i",width() - 4);
	proc << str;
	sprintf(str,"+H%i",height() - 4);
	proc << str << "+Ldata/texture" << "-GA" << "-Odata/texture/preview.ppm" << "-Itexturebody.pov" << "+FP";
	
	proc.start(KProcess::DontCare,KProcess::Stdout);

	x = y = 0;

	tcounter = 0;
	ppmfp = 0;

	startTimer(50);

}

void	PreviewWidget::stop()
{
	if(!ppmfp) return;

	killTimers();
	proc.kill();
	fclose(ppmfp);
	ppmfp = 0;
}

void	PreviewWidget::timerEvent(QTimerEvent*)
{
	unsigned char	buffer[3 * 1024];
	int		i,t,r,g,b;

	if(ppmfp == 0)
	{
		char	buffer[8192];

		tcounter++;
		if(tcounter > 100)	// 100 * 50ms = 5000ms = 5 sec timeout 
		{
			stop();
			return;
		} 
		ppmfp = fopen("data/texture/preview.ppm","rb");
		if(ppmfp == 0) return;
		fgets(buffer,8192,ppmfp);
		fgets(buffer,8192,ppmfp);
		fgets(buffer,8192,ppmfp);
	}

	if((i = fread(buffer,3,1024,ppmfp)) <= 0) return;

	for(t = 0;t < i;t++)
	{
		r = buffer[t * 3];
		g = buffer[t * 3 + 1];
		b = buffer[t * 3 + 2];
		qp->setPen(QColor(r,g,b));
		qp->drawPoint(x++ + 2,y + 2);
		if(x >= width() - 4)
		{
			x = 0;
			y++;
			if(y >= height() - 4)
			{
				stop();
				return;
			}
		}
	}
}

void	PreviewWidget::paintEvent(QPaintEvent*)
{
	FILE		*fp;
	char		buffer[8192];
	int		r,g,b,xx,yy,t,i;

	drawFrame(qp);

	fp = fopen("data/texture/preview.ppm","rb");
	if(fp == 0) return;
	fgets(buffer,8192,fp);
	fgets(buffer,8192,fp);
	fgets(buffer,8192,fp);

	xx = 0;
	yy = 0;

	while((i = fread(buffer,3,1024,fp)) > 0 && !feof(fp))
	{
		for(t = 0;t < i;t++)
		{
			r = (unsigned char)(buffer[t * 3]);
			g = (unsigned char)(buffer[t * 3 + 1]);
			b = (unsigned char)(buffer[t * 3 + 2]);
			qp->setPen(QColor(r,g,b));
			qp->drawPoint(xx++ + 2,yy + 2);
			if(xx >= width() - 4)
			{
				xx = 0;
				yy++;
				if(yy >= height() - 4)
				{
					fclose(fp);
					return;
				}
			}
		}
	}

	fclose(fp);
}

