/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** texturedialog.cpp
*/
#include "texturedialog.h"
#include "texturedialog.moc"




TextureDialog::TextureDialog(QWidget *parent,texture *t) :
	QDialog(parent,"TextureDialog",true)
{

textureBase *tb;
QWidget *w;
int x;
#ifdef DEBUG
	printf("Entering TextureDialog Constructor\n");
#endif
	txt=t;
	setCaption("Texture");

	tab=new TabWidget(this,"",0);

	ok=new QPushButton("Okay",this);
	cancel=new QPushButton("Cancel",this);

	transformations=NULL;
	pigmentwidget=NULL;
	finishwidget=NULL;
	normalwidget=NULL;
	interiorwidget=NULL;
	emptywidget=NULL;
	label2=NULL;

	tb=txt->getFirstElement();
	while (tb!=NULL) {
		if (tb->getType()==TRANSFORMATIONS) {
			tw=new TransformationsWidget(NULL,(Transformations *)tb );
			tw->setCaption("Transformations");
			transformations=new QPushButton("Transformations...",this);
			connect (transformations,SIGNAL(clicked()),this,SLOT(transformationsPressed()) );
                }
		if (tb->getType()==PIGMENT) {
			w=(QWidget *)new PigmentWidget(this,(pigment *)tb);
			pigmentwidget=(PigmentWidget *)w;
			widgetlist.append(w);
			x=widgetlist.length()-1;
			tab->addWidget(w,x,(char *)tb->getName() );
		}
		if (tb->getType()==FINISH) {
			w=(QWidget *)new FinishWidget(this,(finish *)tb );
			finishwidget=(FinishWidget *)w;
			widgetlist.append(w);
			x=widgetlist.length()-1;
			tab->addWidget(w,x,(char *)tb->getName() );		
		}
		if (tb->getType()==NORMAL) {
			w=(QWidget *)new NormalWidget(this,(normal *)tb );
			normalwidget=(NormalWidget *)w;
			widgetlist.append(w);
			x=widgetlist.length()-1;
			tab->addWidget(w,x,(char *)tb->getName() );	
		}
		if (tb->getType()==INTERIOR) {
			w=(QWidget *)new InteriorWidget(this,(interior *)tb );
			interiorwidget=(InteriorWidget *)w;
			widgetlist.append(w);
			x=widgetlist.length()-1;
			tab->addWidget(w,x,(char *)tb->getName() );	
		}
		tb=txt->getNextElement();
	}	

	if (widgetlist.length()==0) {
			label2=new QLabel("Nothing to edit...",this);
	}


	line1=new QLineEdit(this);
        label1=new QLabel("Name:",this);
	line1->setText(txt->getName() );

	connect (ok,SIGNAL(clicked()),this,SLOT(okayPressed()) );
	connect (cancel,SIGNAL(clicked()),this,SLOT(cancelPressed()) );

	addElement=new QPushButton("Add...",this);
	connect(addElement,SIGNAL(clicked()),this,SLOT(addPressed()) );

	tab->select(1);


	resize(580,630);
	setMinimumSize(580,630);
	setMaximumSize(580,630);
#ifdef DEBUG
	printf("Exiting TextureDialog Constructor\n");
#endif
}

void TextureDialog::addPressed()
{
QWidget *w;
int x;
textureBase *tb;
QPopupMenu *Elements;
	
	Elements=new QPopupMenu(this);
	Elements->insertItem("Pigment",1);
	Elements->insertItem("Normal",2);
	Elements->insertItem("Finish",3);
	Elements->insertItem("Interior",4);
	switch(Elements->exec(QCursor::pos() )) {
		case 1:
			tb=new pigment(txt);
			txt->add(tb);
			w=(QWidget *)new PigmentWidget(this,(pigment *)tb);
			pigmentwidget=(PigmentWidget *)w;
			widgetlist.append(w);
			x=widgetlist.length()-1;
			tab->addWidget(w,x,(char *)tb->getName() );
        		tab->select(x);
		break;
		case 2:
			tb=new normal(txt);
			txt->add(tb);
			w=(QWidget *)new NormalWidget(this,(normal *)tb );
			normalwidget=(NormalWidget *)w;
			widgetlist.append(w);
			x=widgetlist.length()-1;
			tab->addWidget(w,x,(char *)tb->getName() );	
        		tab->select(x);
		break;
		case 3:
			tb=new finish(txt);
			txt->add(tb);
			w=(QWidget *)new FinishWidget(this,(finish *)tb );
			finishwidget=(FinishWidget *)w;
			widgetlist.append(w);
			x=widgetlist.length()-1;
			tab->addWidget(w,x,(char *)tb->getName() );		
        		tab->select(x);
		break;
		case 4:
			tb=new interior(txt);
			txt->add(tb);
			w=(QWidget *)new InteriorWidget(this,(interior *)tb );
			interiorwidget=(InteriorWidget *)w;
			widgetlist.append(w);
			x=widgetlist.length()-1;
			tab->addWidget(w,x,(char *)tb->getName() );	
        		tab->select(x);
		break;
	}
	tab->update();
	if (label2) {delete label2;label2=NULL;}
	delete Elements;
}

TextureDialog::~TextureDialog()
{
}

void TextureDialog::cancelPressed()
{
	QDialog::done(0);
}

void TextureDialog::okayPressed()
{
	if (pigmentwidget) pigmentwidget->getPigment();
	if (normalwidget) normalwidget->getNormal();
	if (finishwidget) finishwidget->getFinish();
	if (interiorwidget) interiorwidget->getInterior();
	if (transformations) tw->getTransformations();

        txt->setName(line1->text() );

	QDialog::done(1);
}

void TextureDialog::transformationsPressed()
{
	tw->resize(180,440);
	tw->setMinimumSize(180,440);
	tw->exec();
}

void TextureDialog::paintEvent(QPaintEvent* qp)
{
	int w=width();
	int h=height();
                       	

	label1->setGeometry(10,10,50,25);
	line1->setGeometry(65,10,160,25);
       	addElement->setGeometry(230,10,110,25);

	if (transformations) transformations->setGeometry(w-120,35,110,25);

	tab->setGeometry(15,65,w-30,h-100);	
	if (label2) label2->setGeometry(40,40,140,25);

	cancel->setGeometry(w-65,h-30,60,25);
	ok->setGeometry(w-65-45,h-30,40,25);

	QDialog::paintEvent(qp);
}


