/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** texturedialog.h
*/
#ifndef __TextureDialog_H__
#define __TextureDialog_H__


#include <qwidget.h>
#include <qgroupbox.h>
#include <qpainter.h>
#include <qcolor.h>
#include <qcombobox.h>
#include <kcolorbtn.h>
#include <qdialog.h>
#include <qlineedit.h>

#include <color.h>
#include "../../3d/textures/texture.h"
#include "../misc/vectorwidget.h"
#include "../widgets/tabwidget.h"
#include <qcolor.h>
#include <qlabel.h>
#include <qpopupmenu.h>
#include <qframe.h>

#include "colorwidget.h"
#include "transformationswidget.h"
#include "normaldialog.h"
#include "pigmentdialog.h"
#include "finishdialog.h"
#include "interiordialog.h"


class TextureDialog : public QDialog
{
Q_OBJECT
protected:
	texture  *txt;

	TabWidget	*tab;

	QPushButton		*ok,*cancel;
	QPushButton		*transformations,*addElement;
	QLineEdit		*line1;
	
	QLabel			*label1,*label2,*label3;

	PigmentWidget		*pigmentwidget;
	NormalWidget		*normalwidget;
	InteriorWidget		*interiorwidget;
	FinishWidget		*finishwidget;
	QWidget			*emptywidget;
	
        TransformationsWidget	*tw;

	list<QWidget *>		widgetlist;



public:

	TextureDialog(QWidget *p, texture *);
	~TextureDialog();

protected:
	void	paintEvent(QPaintEvent*);
public slots:

	void okayPressed();
	void cancelPressed();
	void transformationsPressed();
	void addPressed();

};


#endif
