/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** transformationswidget.cpp
*/
#include "transformationswidget.h"
#include "transformationswidget.moc"



TransformationsWidget::TransformationsWidget(QWidget *p,Transformations *t) :
	QDialog(p,"Transformationswidget",true)
{
        tr=t;

	scale=new VectorWidget(this,"Scale");
	rotate=new VectorWidget(this,"Rotate");
	translate=new VectorWidget(this,"Translate");	

        scale->setVector( tr->getScaling() );
        rotate->setVector( tr->getRotation() );
        translate->setVector( tr->getTranslation() );

	ok=new QPushButton("Okay",this);
	cancel=new QPushButton("Cancel",this);
	connect(ok,SIGNAL(clicked()),this,SLOT(OkPressed()));
	connect(cancel,SIGNAL(clicked()),this,SLOT(CancelPressed()));	
	
	resize(200,440);
	setMinimumSize(200,440);
	setMaximumSize(200,440);
}

int TransformationsWidget::exec()
{
	return QDialog::exec();
}

void TransformationsWidget::OkPressed()
{
	#ifdef DEBUG
	printf("Exiting TransformationWidget (accepting values)\n");
	#endif
	getTransformations();
	QDialog::done(1);
}

void TransformationsWidget::CancelPressed()
{
	#ifdef DEBUG
	printf("Exiting TRansformationWidget (REJECTING values)\n");
	#endif
	QDialog::done(0);
}

TransformationsWidget::~TransformationsWidget()
{
}

void TransformationsWidget::getTransformations()
{
	tr->setTranslation( translate->getVector() );
	tr->setRotation(    rotate->getVector()  );	
	tr->setScaling(     scale->getVector()   );
}

void TransformationsWidget::paintEvent(QPaintEvent* qp)
{
	int w=width();
	int h=height();
	
	int a=h/3-20;

	ok->setGeometry(w-120,h-27,40,25);
	cancel->setGeometry(w-75,h-27,70,25);

	scale->setGeometry    (30,10    ,w-40,a);
	rotate->setGeometry   (30,a+10  ,w-40,a);
	translate->setGeometry(30,2*(a+10),w-40,a);

	QDialog::paintEvent(qp);
}


