/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** getfilewidget.h
*/
#ifndef __GETFILEWIDGET_H__
#define __GETFILEWIDGET_H__

#include <qwidget.h>
#include <qlabel.h> 
#include <qstring.h> 
#include <qpushbutton.h>
#include <qmessagebox.h>
#include <qtooltip.h>

#include <qlineedit.h>
#include <kfiledialog.h>
#include <qcombobox.h>
#include <drag.h>
#include <qsize.h>

class	 GetFileWidget : public QWidget
{
Q_OBJECT
protected:
	QLabel			*filenamelabel;
	QPushButton		*FileDialogBt, *clearfile;;
	QLineEdit		*filename;
	KDNDDropZone		*dnd;
	int			GetType; // 0: File 1:Image, 2:Dir, 
	QString 		start;

public:
	GetFileWidget(QWidget *parent,char* name="File",QString path="/",int getImage=0);
	~GetFileWidget();

	QString	getFilename();
	void	setFilename(QString);

	QString	getImageType();

public slots:
	//void	paintEvent(QPaintEvent *);
	void	setGeometry(int,int,int,int);

private slots:
	void	getFile();
	void 	clearFile();
	void 	dropped(KDNDDropZone *);

signals:
	void	changed();
};


#endif

