/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** tabwidget.cpp
*/

#include <klocale.h>
#include "tabwidget.h"
#include "tabwidget.moc"

#include <stdio.h>

//#define stloc(a)	((char*)locale->translate((a)))
#define stloc(a) (a)


TabWidget::TabWidget(QWidget *parent,char *name,int m) :
	QWidget(parent,name)
{
	mode=m;

	wstack=new QWidgetStack(this);
	if (mode==0) {
		tab=new QTabBar(this);
		connect(tab,SIGNAL(selected(int)),this,SLOT(selected(int)) );
	} else {
		combo=new QComboBox(this);
		label=new QLabel(name,this);
		connect(combo,SIGNAL(activated(int)),this,SLOT(selected(int)) );
	}
	wstack->setFrameStyle(QFrame::Panel|QFrame::Raised);
	sel=0;
}

void TabWidget::addWidget(QWidget *w,int nr,char *label)
{

	wstack->addWidget(w,nr);
 	if (mode==0) {
		QTab *t=new QTab();
		t->label=label;
		t->id=nr;
		tab->addTab(t);
	} else {
		combo->insertItem(label,nr);
	}
	printf("Inser Tab at%d\n",nr);
	wstack->raiseWidget(w);
}

void TabWidget::select(int nr)
{
	sel=nr;
	wstack->raiseWidget(nr);
	if (mode==0) tab->setCurrentTab(nr);
	else combo->setCurrentItem(nr);
}

void TabWidget::selected(int nr)
{

	wstack->raiseWidget(nr);
	sel=nr;
}



TabWidget::~TabWidget()
{
}

int TabWidget::getSelected()
{
	return sel;
}

void TabWidget::paintEvent(QPaintEvent* qp)
{
	int w=width();
	int h=height();


	wstack->raiseWidget(sel);
	if (mode==0) tab->setCurrentTab(sel);
	else combo->setCurrentItem(sel);


	if (mode==0) {
		QSize qs=tab->sizeHint();
		wstack->setGeometry(1,qs.height()+1,w-5,h-qs.height()-10);
 		tab->setGeometry(1,3,qs.width(),qs.height()); 	
	} else {
		wstack->setGeometry(1,31,w-5,h-35);
		label->setGeometry(w-w/2-60,0,55,25);
 		combo->setGeometry(w-w/2,3,w/3+30,25); 	
		
	}

	QWidget::paintEvent(qp);

}