#!/bin/sh

echo "mpegav V0.1 (c) 1999 Tobias Wollgam tobias.wollgam@gmx.de"
echo
echo "This script creates a mpeg video with sound."
echo "It needs sox to convert between audio formats,"
echo "encode which creates a mpeg 1 layer 2 audio file,"
echo "and mplex which multiplexes the mpeg 1 video and audio stream."
echo

output="result.mpg"

if test $# -ge 2
then
	bnmpg=`basename $1 .mpg`
	bnall=`basename $1`
	if test $bnmpg = $bnall
	then
		audio=$1
		video=$2
	else
		audio=$2
		video=$1
	fi
fi

if test $# -ge 3
then
	output=$3
else
	echo "Usage: mpegav mpegvideo audiofile [outputfile]"
	exit
fi

echo "[sox]" > mpegav.log
echo "[sox]"
sox $audio tmpaudio.aiff >> mpegav.log

echo "[encode]" >> mpegav.log
echo "[encode]"
encode -b 192 -l 2 -p 2 tmpaudio.aiff tmpaudio.mp2 >> mpegav.log 2> /dev/nul

echo "y" > tmpparam.txt
echo "y" >> tmpparam.txt
echo "2324" >> tmpparam.txt
echo "1" >> tmpparam.txt
echo "46" >> tmpparam.txt
echo "4" >> tmpparam.txt
echo "0" >> tmpparam.txt
echo "0" >> tmpparam.txt
echo "0" >> tmpparam.txt
echo "0" >> tmpparam.txt
echo "n" >> tmpparam.txt

echo "[mplex]" >> mpegav.log
echo "[mplex]"
mplex tmpaudio.mp2 $video $output < tmpparam.txt >> mpegav.log

echo "[cleanup]" >> mpegav.log
echo "[cleanup]"
rm -f tmpaudio.aiff tmpaudio.mp2 tmpparam.txt >> mpegav.log

echo "Ready! Play the $output file."




