/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** boundingbox.h
*/
#ifndef __BOUNDINGBOX_H__
#define __BOUNDINGBOX_H__

#include "matmath.h"

class view;

class boundingbox
{
protected:
	float		vmin[3],vmax[3];

public:
	boundingbox(); 

	virtual	int	calculate(int anim=0);
	int		drawBB(view *,Matrix44,int);

	Vector3		min();
	Vector3		max();
	void		setMin(Vector3 v);
	void		setMax(Vector3 v);
	
	void		addVector(Vector3 v);
};

#endif

