/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** csgobj.h
*/
#ifndef __CSGOBJ_H__
#define __CSGOBJ_H__

#include "atom.h"

class csgobj : public atom
{
public:
	csgobj(base *p=0,const char *n = "Untitled",texture *t=0);
	csgobj(base *p,const char *n,Vector3&,Vector3&,Vector3&); 
	csgobj(base *p,const char *n,texture *t,Vector3&,Vector3&,Vector3&); 
	csgobj(base *p,csgobj *cc); 
	virtual ~csgobj();

	virtual int	exportPOV(FILE*,int tab,int tabsize,int) = 0; 

	virtual void	dumpNames(int tab,int tabsize);

	virtual int	addToParent(base *parent) = 0;
	virtual int	removeFromParent()  { return -1; };

	virtual int	draw(view*,Matrix44,int) = 0; 

 	virtual bool		acceptChild(base*) {return false;};
	virtual bool		acceptChild(body*) {return false;};
	virtual bool		acceptChild(refptr*) {return false;};
	virtual bool		acceptChild(ref*) {return false;};
	virtual bool		acceptChild(csgobj*) {return false;};
	virtual bool		acceptChild(blobobj*) {return false;};
	virtual bool		acceptChild(nonsolid*) {return false;};

 	virtual int		addChild(base*) {return -1;};
	virtual int		addChild(body*) {return -1;};
	virtual int		addChild(refptr*) {return -1;};
	virtual int		addChild(ref*) {return -1;};
	virtual int		addChild(csgobj*) {return -1;};
	virtual int		addChild(blobobj*) {return -1;};
	virtual int		addChild(nonsolid*) {return -1;};

	virtual int		removeChild(base*) {return -1;};
	virtual int		removeChild(body*) {return -1;};
	virtual int		removeChild(refptr*) {return -1;};
	virtual int		removeChild(ref*) {return -1;};
	virtual int		removeChild(csgobj*) {return -1;};
	virtual int		removeChild(blobobj*) {return -1;};
	virtual int		removeChild(nonsolid*) {return -1;};

	virtual int		hasChild(base*) {return -1;};
	virtual int		hasChild(body*) {return -1;};
	virtual int		hasChild(refptr*) {return -1;};
	virtual int		hasChild(ref*) {return -1;};
	virtual int		hasChild(csgobj*) {return -1;};
	virtual int		hasChild(blobobj*) {return -1;};
	virtual int		hasChild(nonsolid*) {return -1;};

	virtual int		moveChild(base*) {return -1;};
	virtual int		moveChild(body*) {return -1;};
	virtual int		moveChild(refptr*) {return -1;};
	virtual int		moveChild(ref*) {return -1;};
	virtual int		moveChild(csgobj*) {return -1;};
	virtual int		moveChild(blobobj*) {return -1;};
	virtual int		moveChild(nonsolid*) {return -1;};
};

#endif

