/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** lightobj.cpp
*/
#include <stdio.h> 
#include <stdlib.h> 
#include <string.h> 

#include "lightobj.h"

lightobj::lightobj(base *p,char *n) :
	csgobj(p,n)
{
	numtype = NUM_LIGHTOBJ;
	
	r = 1;
	g = 1;
	b = 1;
	fade_distance = 0;
	fade_power = 0;
	media_attenuation = false;
	media_interaction = true;
}

lightobj::lightobj(base *p,char *n,Vector3 &vs,Vector3 &vr,Vector3 &vt) :
	csgobj(p,n,vs,vr,vt)
{
	numtype = NUM_LIGHTOBJ;
	
	r = 1;
	g = 1;
	b = 1;
	fade_distance = 0;
	fade_power = 0;
	media_attenuation = false;
	media_interaction = true;
}

lightobj::lightobj(base *p,lightobj *lc) :
	csgobj(p,(csgobj*)lc)
{
	numtype = NUM_LIGHTOBJ;
	
	r = lc->r;
	g = lc->g;
	b = lc->b;
	fade_distance = lc->fade_distance;
	fade_power = lc->fade_power;
	media_attenuation = lc->media_attenuation;
	media_interaction = lc->media_interaction;
}

lightobj::~lightobj()
{
}

void	lightobj::setColor(double c1, double c2, double c3)
{
	r = c1;
	g = c2;
	b = c3;
}

void	lightobj::setColor(Vector3 c)
{
	r = c[0];
	g = c[1];
	b = c[2];
}

void	lightobj::setFadeDistance(double d)
{
	fade_distance = d;
}

void	lightobj::setFadePower(double p)
{
	fade_power = p;
}

void	lightobj::setMediaAttenuation(bool ma)
{
	media_attenuation = ma;
}

void	lightobj::setMediaInteraction(bool mi)
{
	media_interaction = mi;
}

void	lightobj::color(double &rr,double &rg,double &rb)
{
	rr = r;
	rg = g;
	rb = b;
}
	
Vector3	lightobj::color()
{
	Vector3		c(r,g,b);

	return c;
}
	
double	lightobj::red()
{
	return r;
}

double	lightobj::green()
{
	return g;
}

double	lightobj::blue()
{
	return b;
}

double	lightobj::fadeDistance()
{
	return fade_distance;
}

double	lightobj::fadePower()
{
	return fade_distance;
}

bool	lightobj::mediaAttenuation()
{
	return media_attenuation;
}

bool	lightobj::mediaInteraction()
{
	return media_interaction;
}




void	lightobj::dumpNames(int tab,int)
{
	printTab(stdout,tab);
	printf("lightobj: %s\n",name);
}

int	lightobj::addToParent(base *parent)
{
	if(!parent) return -2;
	return parent->addChild(this);
}

double	lightobj::volume(int anim)
{
	return 0;
}



