/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** csg.h
*/
#ifndef __CSG_H__
#define __CSG_H__

#include <list.h>

#include <classes.h>
#include <objects.h>

class csg : public csgobj
{
public:
typedef enum
	{
		UNION,
		MERGE,
		DIFFERENCE,
		INTERSECTION,
		INVERT
	}
	CSG_TYPE;

protected:
	CSG_TYPE	csgtype;
	list<csgobj*>	csglist;

public:
	csg(base *p = 0,const char *n = "Untitled",CSG_TYPE ct = UNION,texture *t=0);
	csg(base *p,const char *n,CSG_TYPE ct,Vector3&,Vector3&,Vector3&); 
	csg(base *p,const char *n,CSG_TYPE ct,texture *t,Vector3&,Vector3&,Vector3&); 
	csg(base *p,csg *cc); 
	~csg();

	CSG_TYPE	getCSGType();
	CSG_TYPE	setCSGType(CSG_TYPE t);

	virtual void	dumpNames(int,int); 
 
	virtual int	save(media*,int);
	virtual int	load(media*,int,int);
 
	virtual int	exportPOV(FILE*,int tab,int tabsize,int anim = 0); 

	virtual int	addToParent(base *parent);
	virtual int	removeFromParent();
	
	virtual bool	acceptChild(csgobj *child);
	virtual bool	acceptChild(blob *child);
	virtual bool	acceptChild(blobobj *child);
	virtual int	addChild(csgobj *child);
	virtual int	addChild(blob *child);
	virtual int	addChild(blobobj *child);
	virtual int	removeChild(csgobj *child);
	virtual int	removeChild(blob *child); 
	virtual int	removeChild(blobobj *child); 

	virtual int	lower(base *child);
 	virtual int	upper(base *child);

	virtual base	*copy(base*);

	virtual void	getChildren(base ***b);
	virtual int	numChildren();

	virtual base	*searchName(const char *n);
	virtual int	existsName(const char *n);

	virtual int	draw(view *,Matrix44,int);
	virtual int	calculate(int);

	virtual double	volume(int anim = 0);
};

#endif

