/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** bitmapmodifier.h
*/
#ifndef __BITMAPMODIFER_H__
#define __BITMAPMODIFER_H__

#include <misc.h>
#include <list.h>
#include <chunk.h>
#include <stdio.h>

#include "texturebase.h"

class bitmapmodifier:public textureBase
{
protected:

	int once,map_type,interpolate;

public:

	bitmapmodifier(textureBase *p=NULL);	
	~bitmapmodifier();
	
	void	setOnce();
	void	unSetOnce();
	void 	setMapType(int);
	void	setInterpolate(int);

	int 	getOnce();
	int	getMapType();
	int	getInterpolate();
	
        bool	canAdd(textureBase *);
	void	add(textureBase *);
	bool 	isEqual(textureBase *);

	int	save(media*);
	int	load(media*,int);

	int	exportPOV(FILE*,int,int, int);
};

#endif
